/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.block.custom;

import com.mojang.serialization.MapCodec;
import net.je.common.block.entity.EnderVaultBlockEntity;
import net.je.common.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class EnderVaultBlock
extends BaseEntityBlock {
    public static final IntegerProperty WAVES_COMPLETE = IntegerProperty.create((String)"waves", (int)0, (int)4);
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final BooleanProperty SHOULD_SPAWN_KEY = BooleanProperty.create((String)"should_spawn_key");
    public static final MapCodec<EnderVaultBlock> CODEC = EnderVaultBlock.simpleCodec(EnderVaultBlock::new);

    public EnderVaultBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)WAVES_COMPLETE, (Comparable)Integer.valueOf(0))).setValue((Property)SHOULD_SPAWN_KEY, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WAVES_COMPLETE, (Comparable)Integer.valueOf(0))).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)SHOULD_SPAWN_KEY, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{WAVES_COMPLETE, ACTIVE, SHOULD_SPAWN_KEY});
    }

    public MapCodec<EnderVaultBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new EnderVaultBlockEntity(pPos, pState);
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return EnderVaultBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.ENDER_VAULT_BLOCK_ENTITY.get()), EnderVaultBlockEntity::tick);
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof EnderVaultBlockEntity) {
            EnderVaultBlockEntity evbe = (EnderVaultBlockEntity)blockEntity;
            if (evbe.finished) {
                double d0 = (double)pPos.getX() + 0.5;
                double d1 = (double)pPos.getY() + 1.0;
                double d2 = (double)pPos.getZ() + 0.5;
                pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }
}

