/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.block.custom;

import com.mojang.serialization.MapCodec;
import net.je.common.block.entity.GravityDistorterBlockEntity;
import net.je.common.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class GravityDistorterBlock
extends BaseEntityBlock {
    public static final MapCodec<GravityDistorterBlock> CODEC = GravityDistorterBlock.simpleCodec(GravityDistorterBlock::new);
    public static final BooleanProperty BLOCK_ABOVE = BooleanProperty.create((String)"block_above");
    public static final BooleanProperty BLOCK_BELOW = BooleanProperty.create((String)"block_below");

    public GravityDistorterBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BLOCK_ABOVE, (Comparable)Boolean.valueOf(false))).setValue((Property)BLOCK_BELOW, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<GravityDistorterBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BLOCK_ABOVE, BLOCK_BELOW});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        boolean above = level.getBlockState(pos.above()).is((Block)this);
        boolean below = level.getBlockState(pos.below()).is((Block)this);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BLOCK_ABOVE, (Comparable)Boolean.valueOf(above))).setValue((Property)BLOCK_BELOW, (Comparable)Boolean.valueOf(below));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GravityDistorterBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return GravityDistorterBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.GRAVITY_DISTORTER_BLOCK_ENTITY.get()), GravityDistorterBlockEntity::tick);
    }

    public void fallOn(Level p_153362_, BlockState p_153363_, BlockPos p_153364_, Entity p_153365_, float p_153366_) {
    }

    public void updateStackHeight(Level level, BlockPos pos) {
        BlockPos top = pos;
        while (level.getBlockState(top.above()).is((Block)this)) {
            top = top.above();
        }
        int height = 0;
        BlockPos current = top;
        while (level.getBlockState(current).is((Block)this)) {
            ++height;
            if ((current = current.below()).getY() >= level.getMinBuildHeight()) continue;
        }
        current = top;
        while (level.getBlockState(current).is((Block)this)) {
            BlockEntity be = level.getBlockEntity(current);
            if (be instanceof GravityDistorterBlockEntity) {
                GravityDistorterBlockEntity gdbe = (GravityDistorterBlockEntity)be;
                gdbe.numBlocksStacked = height;
                gdbe.updateState();
            }
            if ((current = current.below()).getY() >= level.getMinBuildHeight()) continue;
            break;
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean moved) {
        super.neighborChanged(state, level, pos, block, neighborPos, moved);
        if (!level.isClientSide) {
            this.updateStackHeight(level, pos);
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide) {
            this.updateStackHeight(level, pos);
        }
    }

    public void onRemove(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(oldState, level, pos, newState, isMoving);
        if (!level.isClientSide && oldState.getBlock() != newState.getBlock()) {
            this.updateStackHeight(level, pos);
        }
    }
}

