/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.block.custom;

import com.mojang.serialization.MapCodec;
import net.je.common.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class InterdimensionalAnchorBlock
extends Block {
    Level blockLevel;
    public static final IntegerProperty DIMENSION = IntegerProperty.create((String)"dim", (int)0, (int)2);
    public static final MapCodec<InterdimensionalAnchorBlock> CODEC = InterdimensionalAnchorBlock.simpleCodec(InterdimensionalAnchorBlock::new);

    public MapCodec<InterdimensionalAnchorBlock> codec() {
        return CODEC;
    }

    public InterdimensionalAnchorBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)DIMENSION, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{DIMENSION});
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level level;
        this.blockLevel = level = pContext.getLevel();
        if (level.dimension() == Level.OVERWORLD) {
            return (BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DIMENSION, (Comparable)Integer.valueOf(1));
        }
        if (level.dimension() == Level.END) {
            return (BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DIMENSION, (Comparable)Integer.valueOf(2));
        }
        return (BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DIMENSION, (Comparable)Integer.valueOf(0));
    }

    protected void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        RandomSource random;
        super.randomTick(pState, pLevel, pPos, pRandom);
        if (this.blockLevel != null && (random = RandomSource.create()).nextIntBetweenInclusive(1, 4) == 1) {
            if (this.blockLevel.dimension() == Level.OVERWORLD) {
                this.spreadBlock(Blocks.OBSIDIAN, Blocks.CRYING_OBSIDIAN, pLevel, pPos, pRandom);
                this.spreadBlock((Block)ModBlocks.VOIDMASS.get(), (Block)ModBlocks.VOIDBLIGHT.get(), pLevel, pPos, pRandom);
                this.spreadBlock((Block)ModBlocks.VOID_STONE.get(), (Block)ModBlocks.VOIDMASS.get(), pLevel, pPos, pRandom);
                this.spreadBlock((Block)ModBlocks.FADED_END_STONE.get(), (Block)ModBlocks.VOIDMASS.get(), pLevel, pPos, pRandom);
                this.spreadBlock((Block)ModBlocks.CORRUPTED_DIRT.get(), (Block)ModBlocks.VOID_STONE.get(), pLevel, pPos, pRandom);
                this.spreadBlock(Blocks.END_STONE, (Block)ModBlocks.FADED_END_STONE.get(), pLevel, pPos, pRandom);
                this.spreadBlock(Blocks.GRASS_BLOCK, (Block)ModBlocks.CORRUPTED_DIRT.get(), pLevel, pPos, pRandom);
                this.spreadBlock(Blocks.DIRT, (Block)ModBlocks.CORRUPTED_DIRT.get(), pLevel, pPos, pRandom);
                this.spreadBlock(Blocks.STONE, Blocks.END_STONE, pLevel, pPos, pRandom);
            } else if (this.blockLevel.dimension() == Level.END) {
                this.spreadBlock(Blocks.CRYING_OBSIDIAN, Blocks.OBSIDIAN, pLevel, pPos, pRandom);
                this.spreadBlock((Block)ModBlocks.CORRUPTED_DIRT.get(), Blocks.GRASS_BLOCK, pLevel, pPos, pRandom);
                this.spreadBlock((Block)ModBlocks.VOIDBLIGHT.get(), (Block)ModBlocks.VOIDMASS.get(), pLevel, pPos, pRandom);
                this.spreadBlock((Block)ModBlocks.VOIDMASS.get(), (Block)ModBlocks.VOID_STONE.get(), pLevel, pPos, pRandom);
                this.spreadBlock((Block)ModBlocks.VOID_STONE.get(), (Block)ModBlocks.CORRUPTED_DIRT.get(), pLevel, pPos, pRandom);
                this.spreadBlock((Block)ModBlocks.FADED_END_STONE.get(), Blocks.END_STONE, pLevel, pPos, pRandom);
                this.spreadBlock(Blocks.END_STONE, (Block)ModBlocks.CORRUPTED_DIRT.get(), pLevel, pPos, pRandom);
            }
        }
    }

    protected void spreadBlock(Block blockToReplace, Block blockToSpawn, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pLevel.isAreaLoaded(pPos, 3)) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            BlockPos blockpos = pPos.offset(pRandom.nextInt(3) - 1, pRandom.nextInt(5) - 3, pRandom.nextInt(3) - 1);
            if (!pLevel.getBlockState(blockpos).is(blockToReplace)) continue;
            pLevel.setBlockAndUpdate(blockpos, blockToSpawn.defaultBlockState());
        }
    }
}

