/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.block.custom;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.je.common.block.entity.RespawnNexusBlockEntity;
import net.je.common.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class RespawnNexusBlock
extends BaseEntityBlock {
    public static final MapCodec<RespawnNexusBlock> CODEC = RespawnNexusBlock.simpleCodec(RespawnNexusBlock::new);
    public static final BooleanProperty CHARGED = BooleanProperty.create((String)"is_charged");
    private static final ImmutableList<Vec3i> RESPAWN_HORIZONTAL_OFFSETS = ImmutableList.of((Object)new Vec3i(0, 0, -1), (Object)new Vec3i(-1, 0, 0), (Object)new Vec3i(0, 0, 1), (Object)new Vec3i(1, 0, 0), (Object)new Vec3i(-1, 0, -1), (Object)new Vec3i(1, 0, -1), (Object)new Vec3i(-1, 0, 1), (Object)new Vec3i(1, 0, 1));
    private static final ImmutableList<Vec3i> RESPAWN_OFFSETS = new ImmutableList.Builder().addAll(RESPAWN_HORIZONTAL_OFFSETS).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(Vec3i::below).iterator()).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(Vec3i::above).iterator()).add((Object)new Vec3i(0, 1, 0)).build();

    public MapCodec<RespawnNexusBlock> codec() {
        return CODEC;
    }

    public RespawnNexusBlock(BlockBehaviour.Properties p_49773_) {
        super(p_49773_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CHARGED, (Comparable)Boolean.valueOf(false)));
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new RespawnNexusBlockEntity(pPos, pState);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.getValue((Property)CHARGED) != false ? 14 : 0;
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (RespawnNexusBlock.isRespawnFuel(pStack) && !((Boolean)pState.getValue((Property)CHARGED)).booleanValue()) {
            RespawnNexusBlock.charge((Entity)pPlayer, pLevel, pPos, pState);
            pStack.consume(1, (LivingEntity)pPlayer);
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return pHand == InteractionHand.MAIN_HAND && RespawnNexusBlock.isRespawnFuel(pPlayer.getItemInHand(InteractionHand.OFF_HAND)) && (Boolean)pState.getValue((Property)CHARGED) == false ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private static boolean isRespawnFuel(ItemStack pStack) {
        return pStack.is((Item)ModItems.VOIDMETAL_INGOT.get());
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        ServerPlayer serverplayer;
        if (!((Boolean)pState.getValue((Property)CHARGED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        if (!RespawnNexusBlock.canSetSpawn(pLevel)) {
            if (!pLevel.isClientSide) {
                this.explode(pState, pLevel, pPos);
            }
            return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        if (!(pLevel.isClientSide || (serverplayer = (ServerPlayer)pPlayer).getRespawnDimension() == pLevel.dimension() && pPos.equals((Object)serverplayer.getRespawnPosition()))) {
            serverplayer.setRespawnPosition(pLevel.dimension(), pPos, 0.0f, false, true);
            pLevel.playSound(null, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, SoundEvents.RESPAWN_ANCHOR_SET_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    private static boolean isWaterThatWouldFlow(BlockPos pPos, Level pLevel) {
        FluidState fluidstate = pLevel.getFluidState(pPos);
        if (!fluidstate.is(FluidTags.WATER)) {
            return false;
        }
        if (fluidstate.isSource()) {
            return true;
        }
        float f = fluidstate.getAmount();
        if (f < 2.0f) {
            return false;
        }
        FluidState fluidstate1 = pLevel.getFluidState(pPos.below());
        return !fluidstate1.is(FluidTags.WATER);
    }

    private void explode(BlockState pState, Level pLevel, final BlockPos pPos2) {
        pLevel.removeBlock(pPos2, false);
        boolean flag = Direction.Plane.HORIZONTAL.stream().map(arg_0 -> ((BlockPos)pPos2).relative(arg_0)).anyMatch(p_55854_ -> RespawnNexusBlock.isWaterThatWouldFlow(p_55854_, pLevel));
        final boolean flag1 = flag || pLevel.getFluidState(pPos2.above()).is(FluidTags.WATER);
        ExplosionDamageCalculator explosiondamagecalculator = new ExplosionDamageCalculator(this){

            public Optional<Float> getBlockExplosionResistance(Explosion p_55904_, BlockGetter p_55905_, BlockPos p_55906_, BlockState p_55907_, FluidState p_55908_) {
                return p_55906_.equals((Object)pPos2) && flag1 ? Optional.of(Float.valueOf(Blocks.WATER.getExplosionResistance())) : super.getBlockExplosionResistance(p_55904_, p_55905_, p_55906_, p_55907_, p_55908_);
            }
        };
        Vec3 vec3 = pPos2.getCenter();
        pLevel.explode(null, pLevel.damageSources().badRespawnPointExplosion(vec3), explosiondamagecalculator, vec3, 7.0f, true, Level.ExplosionInteraction.BLOCK);
    }

    public static boolean canSetSpawn(Level pLevel) {
        return pLevel.dimension() == Level.END;
    }

    public static void charge(@Nullable Entity pEntity, Level pLevel, BlockPos pPos, BlockState pState) {
        BlockState blockstate = (BlockState)pState.setValue((Property)CHARGED, (Comparable)Boolean.valueOf(true));
        pLevel.setBlock(pPos, blockstate, 3);
        pLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pPos, GameEvent.Context.of((Entity)pEntity, (BlockState)blockstate));
        pLevel.playSound(null, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, SoundEvents.RESPAWN_ANCHOR_CHARGE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.getValue((Property)CHARGED)).booleanValue()) {
            if (pRandom.nextInt(100) == 0) {
                pLevel.playLocalSound(pPos, SoundEvents.RESPAWN_ANCHOR_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            double d0 = (double)pPos.getX() + 0.5 + (0.5 - pRandom.nextDouble());
            double d1 = (double)pPos.getY() + 1.0;
            double d2 = (double)pPos.getZ() + 0.5 + (0.5 - pRandom.nextDouble());
            double d3 = (double)pRandom.nextFloat() * 0.04;
            pLevel.addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, d0, d1, d2, 0.0, d3, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{CHARGED});
    }

    protected boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        return (Boolean)pBlockState.getValue((Property)CHARGED) != false ? 1 : 0;
    }

    public static Optional<Vec3> findStandUpPosition(EntityType<?> pEntityType, CollisionGetter pLevel, BlockPos pPos) {
        Optional<Vec3> optional = RespawnNexusBlock.findStandUpPosition(pEntityType, pLevel, pPos, true);
        return optional.isPresent() ? optional : RespawnNexusBlock.findStandUpPosition(pEntityType, pLevel, pPos, false);
    }

    private static Optional<Vec3> findStandUpPosition(EntityType<?> pEntityType, CollisionGetter pLevel, BlockPos pPos, boolean pSimulate) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Vec3i vec3i : RESPAWN_OFFSETS) {
            blockpos$mutableblockpos.set((Vec3i)pPos).move(vec3i);
            Vec3 vec3 = DismountHelper.findSafeDismountLocation(pEntityType, (CollisionGetter)pLevel, (BlockPos)blockpos$mutableblockpos, (boolean)pSimulate);
            if (vec3 == null) continue;
            return Optional.of(vec3);
        }
        return Optional.empty();
    }

    protected boolean isPathfindable(BlockState pState, PathComputationType pPathComputationType) {
        return false;
    }
}

