/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.block.custom;

import com.mojang.serialization.MapCodec;
import net.je.common.block.entity.ModBlockEntities;
import net.je.common.block.entity.ShadowBeamEmitterBlockEntity;
import net.je.common.particle.ModParticles;
import net.je.common.util.ModTags;
import net.je.config.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;

public class ShadowBeamEmitterBlock
extends BaseEntityBlock {
    public static final MapCodec<ShadowBeamEmitterBlock> CODEC = ShadowBeamEmitterBlock.simpleCodec(ShadowBeamEmitterBlock::new);
    public boolean placedByPlayer;

    public ShadowBeamEmitterBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public MapCodec<ShadowBeamEmitterBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ShadowBeamEmitterBlockEntity(pPos, pState);
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return ShadowBeamEmitterBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.SHADOW_BEAM_EMITTER_BLOCK_ENTITY.get()), ShadowBeamEmitterBlockEntity::tick);
    }

    protected void attack(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        if (((Boolean)CommonConfig.ALLOW_WARDED_BLOCKS.get()).booleanValue()) {
            ItemStack item = pPlayer.getMainHandItem();
            if (!item.is(ModTags.Items.WARDBREAKER) && !pLevel.isClientSide) {
                float i;
                ServerLevel server = (ServerLevel)pLevel;
                for (i = 0.0f; i <= 1.0f; i += 0.2f) {
                    server.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.WARDED_PARTICLES.get()), (double)pPos.getX() - 0.1, (double)pPos.getY() + 0.1, (double)((float)pPos.getZ() + i), 1, 0.0, 0.0, 0.0, 0.1);
                }
                for (i = 0.0f; i <= 1.0f; i += 0.2f) {
                    server.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.WARDED_PARTICLES.get()), (double)((float)pPos.getX() + i), (double)pPos.getY() + 0.1, (double)pPos.getZ() - 0.1, 1, 0.0, 0.0, 0.0, 0.1);
                }
                for (i = 0.0f; i <= 1.0f; i += 0.2f) {
                    server.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.WARDED_PARTICLES.get()), (double)pPos.getX() + 1.1, (double)pPos.getY() + 0.1, (double)((float)pPos.getZ() + i), 1, 0.0, 0.0, 0.0, 0.1);
                }
                for (i = 0.0f; i <= 1.0f; i += 0.2f) {
                    server.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.WARDED_PARTICLES.get()), (double)((float)pPos.getX() + i), (double)pPos.getY() + 0.1, (double)pPos.getZ() + 1.1, 1, 0.0, 0.0, 0.0, 0.1);
                }
            }
        } else {
            super.attack(pState, pLevel, pPos, pPlayer);
        }
    }

    protected float getDestroyProgress(BlockState pState, Player pPlayer, BlockGetter pLevel, BlockPos pPos) {
        if (((Boolean)CommonConfig.ALLOW_WARDED_BLOCKS.get()).booleanValue()) {
            float f = pState.getDestroySpeed(pLevel, pPos);
            ItemStack item = pPlayer.getMainHandItem();
            if (!item.is(ModTags.Items.WARDBREAKER)) {
                return 0.0f;
            }
            if (f == -1.0f) {
                return 0.0f;
            }
            int i = ForgeHooks.isCorrectToolForDrops((BlockState)pState, (Player)pPlayer) ? 30 : 100;
            return pPlayer.getDestroySpeed(pState, pPos) / f / (float)i;
        }
        return super.getDestroyProgress(pState, pPlayer, pLevel, pPos);
    }
}

