/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.block.custom;

import net.je.common.block.entity.ShadowBeamEmitterBlockEntity;
import net.je.common.particle.ModParticles;
import net.je.common.util.ModTags;
import net.je.config.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;

public class ShadowBeamReceiverBlock
extends Block {
    public boolean placedByPlayer;

    public ShadowBeamReceiverBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.notifyEmittersBelow(level, pos);
        super.onPlace(state, level, pos, oldState, isMoving);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            super.onRemove(state, level, pos, newState, isMoving);
            this.notifyEmittersBelow(level, pos);
        } else {
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    private void notifyEmittersBelow(Level level, BlockPos pos) {
        for (int i = 1; i <= 10; ++i) {
            BlockEntity be = level.getBlockEntity(pos.below(i));
            if (!(be instanceof ShadowBeamEmitterBlockEntity)) continue;
            ShadowBeamEmitterBlockEntity emitter = (ShadowBeamEmitterBlockEntity)be;
            emitter.checkForReceiver();
            break;
        }
    }

    protected void attack(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        if (((Boolean)CommonConfig.ALLOW_WARDED_BLOCKS.get()).booleanValue()) {
            ItemStack item = pPlayer.getMainHandItem();
            if (!item.is(ModTags.Items.WARDBREAKER) && !pLevel.isClientSide) {
                float i;
                ServerLevel server = (ServerLevel)pLevel;
                for (i = 0.0f; i <= 1.0f; i += 0.2f) {
                    server.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.WARDED_PARTICLES.get()), (double)pPos.getX() - 0.1, (double)pPos.getY() + 0.1, (double)((float)pPos.getZ() + i), 1, 0.0, 0.0, 0.0, 0.1);
                }
                for (i = 0.0f; i <= 1.0f; i += 0.2f) {
                    server.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.WARDED_PARTICLES.get()), (double)((float)pPos.getX() + i), (double)pPos.getY() + 0.1, (double)pPos.getZ() - 0.1, 1, 0.0, 0.0, 0.0, 0.1);
                }
                for (i = 0.0f; i <= 1.0f; i += 0.2f) {
                    server.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.WARDED_PARTICLES.get()), (double)pPos.getX() + 1.1, (double)pPos.getY() + 0.1, (double)((float)pPos.getZ() + i), 1, 0.0, 0.0, 0.0, 0.1);
                }
                for (i = 0.0f; i <= 1.0f; i += 0.2f) {
                    server.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.WARDED_PARTICLES.get()), (double)((float)pPos.getX() + i), (double)pPos.getY() + 0.1, (double)pPos.getZ() + 1.1, 1, 0.0, 0.0, 0.0, 0.1);
                }
            }
        } else {
            super.attack(pState, pLevel, pPos, pPlayer);
        }
    }

    protected float getDestroyProgress(BlockState pState, Player pPlayer, BlockGetter pLevel, BlockPos pPos) {
        if (((Boolean)CommonConfig.ALLOW_WARDED_BLOCKS.get()).booleanValue()) {
            float f = pState.getDestroySpeed(pLevel, pPos);
            ItemStack item = pPlayer.getMainHandItem();
            if (!item.is(ModTags.Items.WARDBREAKER)) {
                return 0.0f;
            }
            if (f == -1.0f) {
                return 0.0f;
            }
            int i = ForgeHooks.isCorrectToolForDrops((BlockState)pState, (Player)pPlayer) ? 30 : 100;
            return pPlayer.getDestroySpeed(pState, pPos) / f / (float)i;
        }
        return super.getDestroyProgress(pState, pPlayer, pLevel, pPos);
    }
}

