/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.block.custom;

import net.je.common.particle.ModParticles;
import net.je.common.util.ModTags;
import net.je.config.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.ForgeHooks;

public class WardedBlock
extends Block {
    public static final BooleanProperty PLACED = BooleanProperty.create((String)"placed");

    public WardedBlock(BlockBehaviour.Properties properties) {
        super(properties.pushReaction(PushReaction.IGNORE).explosionResistance(3600000.0f));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PLACED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{PLACED});
    }

    protected void attack(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        if (((Boolean)CommonConfig.ALLOW_WARDED_BLOCKS.get()).booleanValue()) {
            ItemStack item = pPlayer.getMainHandItem();
            if (!item.is(ModTags.Items.WARDBREAKER) && !pLevel.isClientSide) {
                float i;
                ServerLevel server = (ServerLevel)pLevel;
                for (i = 0.0f; i <= 1.0f; i += 0.2f) {
                    server.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.WARDED_PARTICLES.get()), (double)pPos.getX() - 0.1, (double)pPos.getY() + 0.1, (double)((float)pPos.getZ() + i), 1, 0.0, 0.0, 0.0, 0.1);
                }
                for (i = 0.0f; i <= 1.0f; i += 0.2f) {
                    server.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.WARDED_PARTICLES.get()), (double)((float)pPos.getX() + i), (double)pPos.getY() + 0.1, (double)pPos.getZ() - 0.1, 1, 0.0, 0.0, 0.0, 0.1);
                }
                for (i = 0.0f; i <= 1.0f; i += 0.2f) {
                    server.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.WARDED_PARTICLES.get()), (double)pPos.getX() + 1.1, (double)pPos.getY() + 0.1, (double)((float)pPos.getZ() + i), 1, 0.0, 0.0, 0.0, 0.1);
                }
                for (i = 0.0f; i <= 1.0f; i += 0.2f) {
                    server.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.WARDED_PARTICLES.get()), (double)((float)pPos.getX() + i), (double)pPos.getY() + 0.1, (double)pPos.getZ() + 1.1, 1, 0.0, 0.0, 0.0, 0.1);
                }
            }
        } else {
            super.attack(pState, pLevel, pPos, pPlayer);
        }
    }

    protected float getDestroyProgress(BlockState pState, Player pPlayer, BlockGetter pLevel, BlockPos pPos) {
        if (((Boolean)CommonConfig.ALLOW_WARDED_BLOCKS.get()).booleanValue()) {
            float f = pState.getDestroySpeed(pLevel, pPos);
            ItemStack item = pPlayer.getMainHandItem();
            if (!item.is(ModTags.Items.WARDBREAKER)) {
                if (((Boolean)pState.getValue((Property)PLACED)).booleanValue()) {
                    float speed = pPlayer.getDestroySpeed(pState, pPos);
                    float hardness = 30000.0f;
                    return speed / hardness;
                }
                return 0.0f;
            }
            if (f == -1.0f) {
                return 0.0f;
            }
            int i = ForgeHooks.isCorrectToolForDrops((BlockState)pState, (Player)pPlayer) ? 30 : 100;
            return pPlayer.getDestroySpeed(pState, pPos) / f / (float)i;
        }
        return super.getDestroyProgress(pState, pPlayer, pLevel, pPos);
    }

    protected float defaultDestroyProgress(BlockState pState, Player pPlayer, BlockGetter pLevel, BlockPos pPos) {
        return super.getDestroyProgress(pState, pPlayer, pLevel, pPos);
    }

    protected void defaultAttack(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        super.attack(pState, pLevel, pPos, pPlayer);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)PLACED, (Comparable)Boolean.valueOf(true));
    }
}

