/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.block.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.je.common.block.ModBlocks;
import net.je.common.block.entity.ModBlockEntities;
import net.je.common.item.ModItems;
import net.je.common.recipe.ModRecipeSerializers;
import net.je.common.screen.EndStoneFurnaceMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class EndStoneFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    public static final int DATA_LIT_TIME = 0;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    int litTime;
    int litDuration;
    int cookingProgress;
    int cookingTotalTime;
    @Nullable
    private static volatile Map<Item, Integer> fuelCache;
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int p_58431_) {
            switch (p_58431_) {
                case 0: {
                    return EndStoneFurnaceBlockEntity.this.litTime;
                }
                case 1: {
                    return EndStoneFurnaceBlockEntity.this.litDuration;
                }
                case 2: {
                    return EndStoneFurnaceBlockEntity.this.cookingProgress;
                }
                case 3: {
                    return EndStoneFurnaceBlockEntity.this.cookingTotalTime;
                }
            }
            return 0;
        }

        public void set(int p_58433_, int p_58434_) {
            switch (p_58433_) {
                case 0: {
                    EndStoneFurnaceBlockEntity.this.litTime = p_58434_;
                    break;
                }
                case 1: {
                    EndStoneFurnaceBlockEntity.this.litDuration = p_58434_;
                    break;
                }
                case 2: {
                    EndStoneFurnaceBlockEntity.this.cookingProgress = p_58434_;
                    break;
                }
                case 3: {
                    EndStoneFurnaceBlockEntity.this.cookingTotalTime = p_58434_;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> quickCheck;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public EndStoneFurnaceBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.END_STONE_FURNACE_BE.get(), pPos, pBlockState);
        this.quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)ModRecipeSerializers.END_STONE_FURNACE_RECIPE_TYPE.get()));
    }

    public static Map<Item, Integer> getFuel() {
        Map<Item, Integer> map = fuelCache;
        if (map != null) {
            return map;
        }
        LinkedHashMap map1 = Maps.newLinkedHashMap();
        EndStoneFurnaceBlockEntity.add(map1, (ItemLike)ModItems.VOIDBLIGHT_BUCKET.get(), 100);
        EndStoneFurnaceBlockEntity.add(map1, (ItemLike)((Block)ModBlocks.VOIDMASS.get()).asItem(), 10);
        EndStoneFurnaceBlockEntity.add(map1, (ItemLike)((Block)ModBlocks.VOIDBLOOM.get()).asItem(), 10);
        fuelCache = map1;
        return map1;
    }

    private static void add(Map<Item, Integer> pMap, ItemLike pItem, int pBurnTime) {
        Item item = pItem.asItem();
        pMap.put(item, pBurnTime);
    }

    public static void invalidateCache() {
        fuelCache = null;
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        this.litTime = pTag.getInt("BurnTime");
        this.cookingProgress = pTag.getInt("CookTime");
        this.cookingTotalTime = pTag.getInt("CookTimeTotal");
        this.litDuration = this.getBurnDuration((ItemStack)this.items.get(1));
        CompoundTag compoundtag = pTag.getCompound("RecipesUsed");
        for (String s : compoundtag.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceLocation.parse((String)s), compoundtag.getInt(s));
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.putInt("BurnTime", this.litTime);
        pTag.putInt("CookTime", this.cookingProgress);
        pTag.putInt("CookTimeTotal", this.cookingTotalTime);
        ContainerHelper.saveAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((p_187449_, p_187450_) -> compoundtag.putInt(p_187449_.toString(), p_187450_.intValue()));
        pTag.put("RecipesUsed", (Tag)compoundtag);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, EndStoneFurnaceBlockEntity pBlockEntity) {
        boolean flag3;
        boolean flag = pBlockEntity.isLit();
        boolean flag1 = false;
        if (pBlockEntity.isLit()) {
            --pBlockEntity.litTime;
        }
        ItemStack itemstack = (ItemStack)pBlockEntity.items.get(1);
        ItemStack itemstack1 = (ItemStack)pBlockEntity.items.get(0);
        boolean flag2 = !itemstack1.isEmpty();
        boolean bl = flag3 = !itemstack.isEmpty();
        if (pBlockEntity.isLit() || flag3 && flag2) {
            RecipeHolder recipeholder = flag2 ? (RecipeHolder)pBlockEntity.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(itemstack1), pLevel).orElse(null) : null;
            int i = pBlockEntity.getMaxStackSize();
            if (!pBlockEntity.isLit() && pBlockEntity.canBurn(pLevel.registryAccess(), recipeholder, pBlockEntity.items, i)) {
                pBlockEntity.litDuration = pBlockEntity.litTime = pBlockEntity.getBurnDuration(itemstack);
                if (pBlockEntity.isLit()) {
                    flag1 = true;
                    if (itemstack.hasCraftingRemainingItem()) {
                        pBlockEntity.items.set(1, (Object)itemstack.getCraftingRemainingItem());
                    } else if (flag3) {
                        itemstack.shrink(1);
                        if (itemstack.isEmpty()) {
                            pBlockEntity.items.set(1, (Object)itemstack.getCraftingRemainingItem());
                        }
                    }
                }
            }
            if (pBlockEntity.isLit() && pBlockEntity.canBurn(pLevel.registryAccess(), recipeholder, pBlockEntity.items, i)) {
                ++pBlockEntity.cookingProgress;
                if (pBlockEntity.cookingProgress == pBlockEntity.cookingTotalTime) {
                    pBlockEntity.cookingProgress = 0;
                    pBlockEntity.cookingTotalTime = EndStoneFurnaceBlockEntity.getTotalCookTime(pLevel, pBlockEntity);
                    if (pBlockEntity.burn(pLevel.registryAccess(), recipeholder, pBlockEntity.items, i)) {
                        pBlockEntity.setRecipeUsed(recipeholder);
                    }
                    flag1 = true;
                }
            } else {
                pBlockEntity.cookingProgress = 0;
            }
        } else if (!pBlockEntity.isLit() && pBlockEntity.cookingProgress > 0) {
            pBlockEntity.cookingProgress = Mth.clamp((int)(pBlockEntity.cookingProgress - 2), (int)0, (int)pBlockEntity.cookingTotalTime);
        }
        if (flag != pBlockEntity.isLit()) {
            flag1 = true;
            pState = (BlockState)pState.setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(pBlockEntity.isLit()));
            pLevel.setBlock(pPos, pState, 3);
        }
        if (flag1) {
            EndStoneFurnaceBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private boolean canBurn(RegistryAccess pRegistryAccess, @Nullable RecipeHolder<?> pRecipe, NonNullList<ItemStack> pInventory, int pMaxStackSize) {
        if (!((ItemStack)pInventory.get(0)).isEmpty() && pRecipe != null) {
            ItemStack itemstack = pRecipe.value().assemble((RecipeInput)new SingleRecipeInput(this.getItem(0)), (HolderLookup.Provider)pRegistryAccess);
            if (itemstack.isEmpty()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)pInventory.get(2);
            if (itemstack1.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemstack1, (ItemStack)itemstack)) {
                return false;
            }
            return itemstack1.getCount() + itemstack.getCount() <= pMaxStackSize && itemstack1.getCount() + itemstack.getCount() <= itemstack1.getMaxStackSize() ? true : itemstack1.getCount() + itemstack.getCount() <= itemstack.getMaxStackSize();
        }
        return false;
    }

    private boolean burn(RegistryAccess pRegistryAccess, @Nullable RecipeHolder<?> pRecipe, NonNullList<ItemStack> pInventory, int pMaxStackSize) {
        if (pRecipe != null && this.canBurn(pRegistryAccess, pRecipe, pInventory, pMaxStackSize)) {
            ItemStack itemstack = (ItemStack)pInventory.get(0);
            ItemStack itemstack1 = pRecipe.value().assemble((RecipeInput)new SingleRecipeInput(this.getItem(0)), (HolderLookup.Provider)pRegistryAccess);
            ItemStack itemstack2 = (ItemStack)pInventory.get(2);
            if (itemstack2.isEmpty()) {
                pInventory.set(2, (Object)itemstack1.copy());
            } else if (ItemStack.isSameItemSameComponents((ItemStack)itemstack2, (ItemStack)itemstack1)) {
                itemstack2.grow(itemstack1.getCount());
            }
            itemstack.shrink(1);
            return true;
        }
        return false;
    }

    protected int getBurnDuration(ItemStack pFuel) {
        if (pFuel.is((Item)ModItems.VOIDBLIGHT_BUCKET.get())) {
            return 100;
        }
        if (pFuel.is(((Block)ModBlocks.VOIDBLOOM.get()).asItem()) || pFuel.is(((Block)ModBlocks.VOIDMASS.get()).asItem())) {
            return 10;
        }
        return 0;
    }

    private static int getTotalCookTime(Level pLevel, EndStoneFurnaceBlockEntity pBlockEntity) {
        SingleRecipeInput singlerecipeinput = new SingleRecipeInput(pBlockEntity.getItem(0));
        return pBlockEntity.quickCheck.getRecipeFor((RecipeInput)singlerecipeinput, pLevel).map(p_296950_ -> ((AbstractCookingRecipe)p_296950_.value()).getCookingTime()).orElse(200);
    }

    public static boolean isFuel(ItemStack pStack) {
        return pStack.is((Item)ModItems.VOIDBLIGHT_BUCKET.get()) || pStack.is(((Block)ModBlocks.VOIDBLOOM.get()).asItem()) || pStack.is(((Block)ModBlocks.VOIDMASS.get()).asItem());
    }

    public int[] getSlotsForFace(Direction pSide) {
        if (pSide == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return pSide == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean canPlaceItemThroughFace(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return this.canPlaceItem(pIndex, pItemStack);
    }

    public boolean canTakeItemThroughFace(int pIndex, ItemStack pStack, Direction pDirection) {
        return pDirection == Direction.DOWN && pIndex == 1 ? pStack.is(Items.WATER_BUCKET) || pStack.is(Items.BUCKET) : true;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> pItems) {
        this.items = pItems;
    }

    public void setItem(int pIndex, ItemStack pStack) {
        ItemStack itemstack = (ItemStack)this.items.get(pIndex);
        boolean flag = !pStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)pStack);
        this.items.set(pIndex, (Object)pStack);
        pStack.limitSize(this.getMaxStackSize(pStack));
        if (pIndex == 0 && !flag) {
            this.cookingTotalTime = EndStoneFurnaceBlockEntity.getTotalCookTime(this.level, this);
            this.cookingProgress = 0;
            this.setChanged();
        }
    }

    public boolean canPlaceItem(int pIndex, ItemStack pStack) {
        if (pIndex == 2) {
            return false;
        }
        if (pIndex != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.items.get(1);
        return pStack.is((Item)ModItems.VOIDBLIGHT_BUCKET.get()) || pStack.is(((Block)ModBlocks.VOIDBLOOM.get()).asItem()) || pStack.is(((Block)ModBlocks.VOIDMASS.get()).asItem()) || pStack.is(Items.BUCKET) && !itemstack.is(Items.BUCKET);
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> pRecipe) {
        if (pRecipe != null) {
            ResourceLocation resourcelocation = pRecipe.id();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void awardUsedRecipes(Player pPlayer, List<ItemStack> pItems) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer pPlayer) {
        List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience(pPlayer.serverLevel(), pPlayer.position());
        pPlayer.awardRecipes(list);
        for (RecipeHolder<?> recipeholder : list) {
            if (recipeholder == null) continue;
            pPlayer.triggerRecipeCrafted(recipeholder, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel pLevel, Vec3 pPopVec) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            pLevel.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(p_296949_ -> {
                list.add(p_296949_);
                EndStoneFurnaceBlockEntity.createExperience(pLevel, pPopVec, entry.getIntValue(), ((AbstractCookingRecipe)p_296949_.value()).getExperience());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel pLevel, Vec3 pPopVec, int pRecipeIndex, float pExperience) {
        int i = Mth.floor((float)((float)pRecipeIndex * pExperience));
        float f = Mth.frac((float)((float)pRecipeIndex * pExperience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.award((ServerLevel)pLevel, (Vec3)pPopVec, (int)i);
    }

    public void fillStackedContents(StackedContents pHelper) {
        for (ItemStack itemstack : this.items) {
            pHelper.accountStack(itemstack);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && facing != null && !this.remove) {
            return switch (facing) {
                case Direction.UP -> this.handlers[0].cast();
                case Direction.DOWN -> this.handlers[1].cast();
                default -> this.handlers[2].cast();
            };
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.je.end_stone_furnace");
    }

    protected AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory) {
        return new EndStoneFurnaceMenu(pContainerId, pInventory, (Container)this, this.dataAccess);
    }
}

