/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.block.entity;

import net.je.common.block.ModBlocks;
import net.je.common.block.custom.EnderVaultBlock;
import net.je.common.block.entity.ModBlockEntities;
import net.je.common.entity.ModEntities;
import net.je.common.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EnderVaultBlockEntity
extends BlockEntity {
    private int delayBetweenWaves = 0;
    private static final int DELAY_AMOUNT = 120;
    public boolean finished = false;
    private static final int SPAWN_RANGE = 7;
    private static final float PLAYER_DETECTION_RANGE = 5.0f;
    public boolean shouldSpawnKey = false;

    public EnderVaultBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.ENDER_VAULT_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, EnderVaultBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide()) {
            if (pBlockEntity.delayBetweenWaves <= 0) {
                pBlockEntity.updateActive(pLevel, pPos);
                if (pBlockEntity.isActive()) {
                    if (pBlockEntity.getCurrentWave() == 4) {
                        pBlockEntity.finished = true;
                        pBlockEntity.updateActive(pLevel, pPos);
                        pBlockEntity.setChanged();
                        pLevel.sendBlockUpdated(pBlockEntity.worldPosition, pBlockEntity.getBlockState(), pBlockEntity.getBlockState(), 3);
                        if (((Boolean)pState.getValue((Property)EnderVaultBlock.SHOULD_SPAWN_KEY)).booleanValue() || pBlockEntity.shouldSpawnKey) {
                            ItemStack key = new ItemStack((ItemLike)ModItems.SHADOW_KEY.get());
                            DefaultDispenseItemBehavior.spawnItem((Level)pLevel, (ItemStack)key, (int)2, (Direction)Direction.UP, (Position)Vec3.atBottomCenterOf((Vec3i)pPos).relative(Direction.UP, 1.2));
                        }
                    } else if (pBlockEntity.getCurrentWave() == 3) {
                        pBlockEntity.wave4();
                    } else if (pBlockEntity.getCurrentWave() == 2) {
                        pBlockEntity.wave3();
                    } else if (pBlockEntity.getCurrentWave() == 1) {
                        pBlockEntity.wave2();
                    } else {
                        pBlockEntity.wave1();
                    }
                }
            } else {
                --pBlockEntity.delayBetweenWaves;
            }
        }
    }

    public static boolean checkForPlayers(Level pLevel, BlockPos pPos) {
        if (!pLevel.isClientSide()) {
            Player player = pLevel.getNearestPlayer((double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), 5.0, false);
            return player != null && !(player.getY() < (double)pPos.getY());
        }
        return false;
    }

    public int getCurrentWave() {
        return (Integer)this.getBlockState().getValue((Property)EnderVaultBlock.WAVES_COMPLETE);
    }

    public void setCurrentWave(int num) {
        if (this.level != null) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)((BlockState)((BlockState)((Block)ModBlocks.ENDER_VAULT.get()).defaultBlockState().setValue((Property)EnderVaultBlock.ACTIVE, (Comparable)((Boolean)this.getBlockState().getValue((Property)EnderVaultBlock.ACTIVE)))).setValue((Property)EnderVaultBlock.WAVES_COMPLETE, (Comparable)Integer.valueOf(Math.clamp((long)num, 0, 4)))).setValue((Property)EnderVaultBlock.SHOULD_SPAWN_KEY, (Comparable)((Boolean)this.getBlockState().getValue((Property)EnderVaultBlock.SHOULD_SPAWN_KEY))));
        }
    }

    public void wave1() {
        this.setCurrentWave(1);
        this.updateWavesComplete();
        this.delayBetweenWaves = 120;
        if (this.level != null && this.canSpawnInLevel(this.level)) {
            this.spawnMobs(this.level, this.worldPosition, (EntityType)ModEntities.ECHO.get(), 3);
        }
    }

    public void wave2() {
        this.setCurrentWave(2);
        this.updateWavesComplete();
        this.delayBetweenWaves = 120;
        if (this.level != null && this.canSpawnInLevel(this.level)) {
            this.spawnMobs(this.level, this.worldPosition, (EntityType)ModEntities.ECHO.get(), 3);
        }
    }

    public void wave3() {
        this.setCurrentWave(3);
        this.updateWavesComplete();
        this.delayBetweenWaves = 120;
        if (this.level != null && this.canSpawnInLevel(this.level)) {
            this.spawnMobs(this.level, this.worldPosition, (EntityType)ModEntities.ECHO.get(), 3);
        }
    }

    public void wave4() {
        this.setCurrentWave(4);
        this.updateWavesComplete();
        this.delayBetweenWaves = 120;
        if (this.level != null && this.canSpawnInLevel(this.level)) {
            this.spawnMobs(this.level, this.worldPosition, (EntityType)ModEntities.ECHO.get(), 3);
        }
    }

    public void spawnMobs(Level pLevel, BlockPos pPos, EntityType<?> type, int count) {
        for (int i = 0; i < count; ++i) {
            Mob mob;
            BlockPos pos = this.findSpawnPos(pPos, pLevel, type);
            if (pos == null) {
                for (int attempt = 0; attempt < 3 && pos == null; ++attempt) {
                    pos = this.findSpawnPos(pPos, pLevel, type);
                }
            }
            if (pos == null || (mob = (Mob)type.create(pLevel)) == null) continue;
            mob.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, pLevel.random.nextFloat() * 360.0f, 0.0f);
            pLevel.addFreshEntity((Entity)mob);
        }
    }

    private BlockPos findSpawnPos(BlockPos pPos, Level pLevel, EntityType<?> type) {
        RandomSource randomsource = pLevel.getRandom();
        int d0 = (int)((double)pPos.getX() + (randomsource.nextDouble() - randomsource.nextDouble()) * 7.0 + 0.5);
        int d1 = pPos.getY() + randomsource.nextInt(3) - 1;
        int d2 = (int)((double)pPos.getZ() + (randomsource.nextDouble() - randomsource.nextDouble()) * 7.0 + 0.5);
        BlockPos pos = new BlockPos(d0, d1, d2);
        for (int i = 0; i < 5; ++i) {
            AABB box;
            BlockPos checkPos = pos.above(i);
            if (!pLevel.getBlockState(checkPos.below()).isSolid() || !pLevel.isEmptyBlock(checkPos) || !pLevel.isEmptyBlock(checkPos.above()) || !pLevel.noCollision(box = type.getDimensions().makeBoundingBox((double)checkPos.getX() + 0.5, (double)checkPos.getY(), (double)checkPos.getZ() + 0.5))) continue;
            return checkPos;
        }
        return null;
    }

    private boolean canSpawnInLevel(Level pLevel) {
        return pLevel.getDifficulty() == Difficulty.PEACEFUL ? false : pLevel.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING);
    }

    private void updateWavesComplete() {
        if (this.level != null) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)((BlockState)((BlockState)((Block)ModBlocks.ENDER_VAULT.get()).defaultBlockState().setValue((Property)EnderVaultBlock.ACTIVE, (Comparable)((Boolean)this.getBlockState().getValue((Property)EnderVaultBlock.ACTIVE)))).setValue((Property)EnderVaultBlock.WAVES_COMPLETE, (Comparable)Integer.valueOf(this.getCurrentWave()))).setValue((Property)EnderVaultBlock.SHOULD_SPAWN_KEY, (Comparable)((Boolean)this.getBlockState().getValue((Property)EnderVaultBlock.SHOULD_SPAWN_KEY))));
        }
    }

    private void updateActive(Level pLevel, BlockPos pPos) {
        boolean playerNearby = EnderVaultBlockEntity.checkForPlayers(pLevel, pPos);
        pLevel.setBlockAndUpdate(pPos, (BlockState)((BlockState)((BlockState)((Block)ModBlocks.ENDER_VAULT.get()).defaultBlockState().setValue((Property)EnderVaultBlock.ACTIVE, (Comparable)Boolean.valueOf(playerNearby && !this.finished))).setValue((Property)EnderVaultBlock.WAVES_COMPLETE, (Comparable)((Integer)this.getBlockState().getValue((Property)EnderVaultBlock.WAVES_COMPLETE)))).setValue((Property)EnderVaultBlock.SHOULD_SPAWN_KEY, (Comparable)((Boolean)this.getBlockState().getValue((Property)EnderVaultBlock.SHOULD_SPAWN_KEY))));
    }

    private boolean isActive() {
        return (Boolean)this.getBlockState().getValue((Property)EnderVaultBlock.ACTIVE);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("Finished", this.finished);
        tag.putInt("delayBetweenWaves", this.delayBetweenWaves);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.finished = tag.getBoolean("Finished");
        this.delayBetweenWaves = tag.getInt("delayBetweenWaves");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putBoolean("Finished", this.finished);
        tag.putInt("delayBetweenWaves", this.delayBetweenWaves);
        return tag;
    }
}

