/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.block.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.je.common.block.custom.GravityDistorterBlock;
import net.je.common.block.entity.ModBlockEntities;
import net.je.config.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GravityDistorterBlockEntity
extends BlockEntity {
    public int numBlocksStacked = 1;
    private boolean isTopBlockInStack;
    private boolean isCovered;
    private int levitationAmount;
    private AABB cachedArea;
    private final Set<UUID> levitatedEntities = new HashSet<UUID>();

    public GravityDistorterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.GRAVITY_DISTORTER_BLOCK_ENTITY.get(), pos, state);
    }

    public void onLoad() {
        this.updateState();
    }

    public void updateState() {
        if (this.level == null) {
            return;
        }
        BlockState state = this.getBlockState();
        this.isTopBlockInStack = (Boolean)state.getValue((Property)GravityDistorterBlock.BLOCK_ABOVE) == false;
        this.isCovered = !this.level.isEmptyBlock(this.worldPosition.above());
        this.levitationAmount = Math.min(this.numBlocksStacked, 10);
        this.updateLevitationArea();
        this.setChanged();
        if (!this.level.isClientSide) {
            BlockState bs = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, bs, bs, 2);
        }
    }

    private void updateLevitationArea() {
        if (this.level == null) {
            return;
        }
        this.cachedArea = new AABB(this.worldPosition).expandTowards(0.0, (double)(5 * this.levitationAmount), 0.0);
    }

    public AABB getLevitationArea() {
        return this.cachedArea;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GravityDistorterBlockEntity be) {
        if (level.isClientSide()) {
            return;
        }
        if (!be.isTopBlockInStack || be.isCovered) {
            return;
        }
        if (be.cachedArea == null) {
            be.updateLevitationArea();
        }
        List entities = level.getEntitiesOfClass(LivingEntity.class, be.cachedArea);
        for (LivingEntity entity : entities) {
            ServerPlayer player;
            if (!GravityDistorterBlockEntity.isAtBlock(entity, be.getBlockPos()) || !be.hasClearPathToEntity(level, pos, entity) || entity instanceof ServerPlayer && ((player = (ServerPlayer)entity).isShiftKeyDown() || player.isCreative() && !((Boolean)CommonConfig.GRAVITY_DISTORTER_WORKS_IN_CREATIVE.get()).booleanValue())) continue;
            be.levitateEntity(entity, pos, level);
            if (!(entity instanceof ServerPlayer)) continue;
            player = (ServerPlayer)entity;
            player.hurtMarked = true;
        }
    }

    private boolean hasClearPathToEntity(Level level, BlockPos pos, LivingEntity entity) {
        int startY = pos.getY() + 1;
        int endY = Mth.floor((double)entity.getY());
        for (int y = startY; y <= endY; ++y) {
            BlockPos checkPos = new BlockPos(pos.getX(), y, pos.getZ());
            if (level.isEmptyBlock(checkPos)) continue;
            return false;
        }
        return true;
    }

    private void levitateEntity(LivingEntity entity, BlockPos pos, Level pLevel) {
        double topY = pos.getY() + 5 * this.levitationAmount;
        double currentY = entity.getY();
        Vec3 motion = entity.getDeltaMovement();
        float friction = entity.level().getBlockState(entity.blockPosition()).getFriction((LevelReader)entity.level(), entity.blockPosition(), (Entity)entity);
        Vec3 horizontal = entity.handleRelativeFrictionAndCalculateMovement(motion, friction);
        double targetY = 0.3;
        entity.setDeltaMovement(horizontal.x, targetY, horizontal.z);
        entity.fallDistance = 0.0f;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.hurtMarked = true;
        }
    }

    private static boolean isAtBlock(LivingEntity entity, BlockPos pos) {
        return Mth.floor((double)entity.getX()) == pos.getX() && Mth.floor((double)entity.getZ()) == pos.getZ();
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("NumBlocksStacked", this.numBlocksStacked);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.numBlocksStacked = tag.getInt("NumBlocksStacked");
        this.updateState();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
        this.updateState();
    }
}

