/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.block.entity;

import java.util.List;
import net.je.common.block.ModBlocks;
import net.je.common.block.entity.ModBlockEntities;
import net.je.common.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class ShadowBeamEmitterBlockEntity
extends BlockEntity {
    private boolean isActive = false;
    private int beamHeight = 0;
    public int laserTicks = 0;
    public int laserCooldownTicks = 0;
    private AABB laserDamageArea;
    boolean laserActive = false;

    public ShadowBeamEmitterBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.SHADOW_BEAM_EMITTER_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public void checkForReceiver() {
        BlockPos abovePos;
        BlockState state;
        if (this.level == null) {
            return;
        }
        boolean found = false;
        int height = 0;
        for (int i = 1; i <= 10 && !(state = this.level.getBlockState(abovePos = this.worldPosition.above(i))).is((Block)ModBlocks.SHADOW_BEAM_EMITTER.get()); ++i) {
            if (!state.is((Block)ModBlocks.SHADOW_BEAM_RECEIVER.get()) || i <= 1) continue;
            found = true;
            height = i - 1;
            this.laserDamageArea = new AABB(this.worldPosition).expandTowards(0.0, (double)height, 0.0);
            break;
        }
        this.isActive = found;
        this.beamHeight = height;
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public void onLoad() {
        this.checkForReceiver();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ShadowBeamEmitterBlockEntity be) {
        if (!level.isClientSide()) {
            if (level.getGameTime() % 20L == 0L) {
                be.checkForReceiver();
            }
            be.laserActive = true;
            if (be.isActive()) {
                boolean previousLaserActive = be.laserActive;
                if (be.laserTicks > 0) {
                    be.laserActive = true;
                    be.damageEntitiesInBeam(be);
                    --be.laserTicks;
                } else if (be.laserCooldownTicks > 0) {
                    be.laserActive = false;
                    --be.laserCooldownTicks;
                } else {
                    be.laserTicks = 40;
                    be.laserCooldownTicks = 20;
                    be.laserActive = true;
                    be.setChanged();
                    level.sendBlockUpdated(be.worldPosition, be.getBlockState(), be.getBlockState(), 3);
                    be.damageEntitiesInBeam(be);
                }
                if (previousLaserActive != be.laserActive) {
                    be.setChanged();
                    level.sendBlockUpdated(be.worldPosition, be.getBlockState(), be.getBlockState(), 3);
                }
            } else {
                be.laserTicks = 0;
                be.laserCooldownTicks = 0;
                be.laserActive = false;
            }
        }
    }

    public void damageEntitiesInBeam(ShadowBeamEmitterBlockEntity be) {
        if (this.level == null || this.laserDamageArea == null || !this.isActive()) {
            return;
        }
        if (this.level.getGameTime() % 2L != 0L) {
            return;
        }
        List entities = this.level.getEntitiesOfClass(LivingEntity.class, this.laserDamageArea);
        for (LivingEntity entity : entities) {
            ServerPlayer player;
            if (entity instanceof ServerPlayer && (player = (ServerPlayer)entity).isCreative() || entity.getType().is(ModTags.Entities.SHADOW_MOBS) || this.laserTicks <= 0 || !this.laserActive || !ShadowBeamEmitterBlockEntity.isAtBlock(entity, this.getBlockPos())) continue;
            entity.hurt(this.level.damageSources().magic(), 2.0f);
            entity.invulnerableTime = 1;
            entity.hurtMarked = false;
        }
    }

    private static boolean isAtBlock(LivingEntity entity, BlockPos pos) {
        return Mth.floor((double)entity.getX()) == pos.getX() && Mth.floor((double)entity.getZ()) == pos.getZ();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public int getBeamHeight() {
        return this.beamHeight;
    }

    public boolean laserActive() {
        return this.laserActive;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.worldPosition).expandTowards(0.0, (double)(this.beamHeight + 1), 0.0);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("Active", this.isActive);
        tag.putInt("BeamHeight", this.beamHeight);
        tag.putBoolean("LaserActive", this.laserActive);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.isActive = tag.getBoolean("Active");
        this.beamHeight = tag.getInt("BeamHeight");
        this.laserActive = tag.getBoolean("LaserActive");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putBoolean("Active", this.isActive);
        tag.putInt("BeamHeight", this.beamHeight);
        tag.putBoolean("LaserActive", this.laserActive);
        return tag;
    }
}

