/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.block.entity;

import java.util.List;
import net.je.common.block.ModBlocks;
import net.je.common.block.entity.ModBlockEntities;
import net.je.common.block.entity.ShadowPrismBlockEntity;
import net.je.common.entity.custom.ShadowLord;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class UnstableShadowPrismBlockEntity
extends ShadowPrismBlockEntity {
    public int activeTicks = 0;
    public int ticksUntilLaser = 0;
    private AABB laserDamageArea;
    public static final int BEAM_HEIGHT = 6;

    public UnstableShadowPrismBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.UNSTABLE_SHADOW_PRISM_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public void onLoad() {
        this.ticksUntilLaser = 40;
        this.laserDamageArea = new AABB(this.worldPosition).expandTowards(0.0, 6.0, 0.0);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.worldPosition).expandTowards(0.0, 6.0, 0.0);
    }

    public boolean isActive() {
        return this.activeTicks > 0;
    }

    public boolean laserIsCharging() {
        return this.ticksUntilLaser > 0;
    }

    public void startLaser() {
        this.activeTicks = 20;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, UnstableShadowPrismBlockEntity be) {
        if (be.laserIsCharging()) {
            --be.ticksUntilLaser;
            if (!be.laserIsCharging()) {
                be.startLaser();
            }
        }
        if (be.isActive()) {
            --be.activeTicks;
            if (!level.isClientSide() && level.getGameTime() % 2L == 0L) {
                List entities = level.getEntitiesOfClass(LivingEntity.class, be.laserDamageArea);
                for (LivingEntity entity : entities) {
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        if (player.isCreative() || !UnstableShadowPrismBlockEntity.isAtBlock((LivingEntity)player, be.getBlockPos())) continue;
                        player.hurt(level.damageSources().magic(), 1.0f);
                        player.invulnerableTime = 1;
                        player.hurtMarked = false;
                        continue;
                    }
                    if (entity instanceof ShadowLord) {
                        ShadowLord shadowLord = (ShadowLord)entity;
                        continue;
                    }
                    if (!UnstableShadowPrismBlockEntity.isAtBlock(entity, be.getBlockPos())) continue;
                    entity.hurt(level.damageSources().magic(), 2.0f);
                    entity.invulnerableTime = 1;
                    entity.hurtMarked = false;
                }
            }
            if (!be.isActive()) {
                level.setBlockAndUpdate(pos, ((Block)ModBlocks.WARDED_FADED_END_STONE_BRICKS.get()).defaultBlockState());
            }
        }
    }

    private static boolean isAtBlock(LivingEntity entity, BlockPos pos) {
        return Mth.floor((double)entity.getX()) == pos.getX() && Mth.floor((double)entity.getZ()) == pos.getZ();
    }
}

