/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.je.config.CommonConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class ModConfigEnabledCondition
implements ICondition {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"je", (String)"config_enabled");
    public static final MapCodec<ModConfigEnabledCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("key").forGetter(cond -> cond.key)).apply((Applicative)instance, ModConfigEnabledCondition::new));
    private final String key;

    public ModConfigEnabledCondition(String pkey) {
        this.key = pkey;
    }

    public boolean test(ICondition.IContext context, DynamicOps<?> ops) {
        return this.getConfigValue(this.key);
    }

    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }

    private boolean getConfigValue(String pkey) {
        boolean value = switch (pkey) {
            case "vanilla_eye_recipe_enabled" -> (Boolean)CommonConfig.ENABLE_VANILLA_EYE_RECIPE.get();
            case "eye_requires_echo_shards" -> (Boolean)CommonConfig.EYE_REQUIRES_ECHO_SHARDS.get();
            default -> false;
        };
        return value;
    }
}

