/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.datagen;

import java.util.LinkedHashMap;
import net.je.common.block.ModBlocks;
import net.je.common.item.ModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    private static final LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "je", existingFileHelper);
    }

    protected void registerModels() {
        this.basicItem((Item)ModItems.VOIDBLIGHT_BUCKET.get());
        this.basicItem((Item)ModItems.VOID_DUST.get());
        this.basicItem((Item)ModItems.SMALL_VOID_DUST.get());
        this.basicItem((Item)ModItems.RAW_VOIDMETAL.get());
        this.basicItem((Item)ModItems.VOIDMETAL_INGOT.get());
        this.basicItem((Item)ModItems.VOIDMETAL_NUGGET.get());
        this.basicItem((Item)ModItems.VOIDMETAL_UPGRADE_SMITHING_TEMPLATE.get());
        this.basicItem((Item)ModItems.EYE_FRAGMENT.get());
        this.basicItem((Item)ModItems.TIMEWORN_JOURNAL_T0.get());
        this.basicItem((Item)ModItems.TIMEWORN_JOURNAL_T1.get());
        this.basicItem((Item)ModItems.TIMEWORN_JOURNAL_T2.get());
        this.basicItem((Item)ModItems.SHADOW_KEY.get());
        this.handheldItem(ModItems.VOIDMETAL_PICKAXE);
        this.handheldItem(ModItems.VOIDMETAL_AXE);
        this.handheldItem(ModItems.VOIDMETAL_SHOVEL);
        this.handheldItem(ModItems.VOIDMETAL_HOE);
        this.handheldItem(ModItems.VOIDMETAL_SWORD);
        this.handheldItem(ModItems.SHADOW_STEEL_SWORD);
        this.handheldItem(ModItems.WARDBREAKER_PICKAXE);
        this.trimmedArmorItem(ModItems.VOIDMETAL_HELMET);
        this.trimmedArmorItem(ModItems.VOIDMETAL_CHESTPLATE);
        this.trimmedArmorItem(ModItems.VOIDMETAL_LEGGINGS);
        this.trimmedArmorItem(ModItems.VOIDMETAL_BOOTS);
        this.wallItem(ModBlocks.POLISHED_END_STONE_WALL, ModBlocks.POLISHED_END_STONE);
        this.wallItem(ModBlocks.SHADOW_STONE_WALL, ModBlocks.SHADOW_STONE);
        this.wallItem(ModBlocks.SHADOW_STONE_BRICK_WALL, ModBlocks.SHADOW_STONE_BRICKS);
        this.wallItem(ModBlocks.POLISHED_SHADOW_STONE_WALL, ModBlocks.POLISHED_SHADOW_STONE);
        this.blockItem((Block)ModBlocks.SHADOW_BLOCK.get());
        this.blockItem((Block)ModBlocks.ECLIPSED_SHADOW_BLOCK.get());
        this.blockItem((Block)ModBlocks.BOUND_OBSIDIAN.get());
    }

    private ItemModelBuilder blockItem(Block block) {
        return (ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)block).getPath(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)block).getPath()));
    }

    private ItemModelBuilder handheldItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"je", (String)("item/" + item.getId().getPath())));
    }

    private void trimmedArmorItem(RegistryObject<Item> itemRegistryObject) {
        String MOD_ID = "je";
        Object object = itemRegistryObject.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.forEach((trimMaterial, value) -> {
                float trimValue = value.floatValue();
                String armorType = switch (armorItem.getEquipmentSlot()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = armorItem.toString();
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.location().getPath();
                String currentTrimName = armorItemPath + "_" + trimMaterial.location().getPath() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.parse((String)armorItemPath);
                ResourceLocation trimResLoc = ResourceLocation.parse((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.parse((String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc.getNamespace() + ":item/" + armorItemResLoc.getPath())).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemRegistryObject.getId().getPath(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc.getNamespace() + ":item/" + trimNameResLoc.getPath())).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"je", (String)("item/" + itemRegistryObject.getId().getPath())));
            });
        }
    }

    public void wallItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", ResourceLocation.fromNamespaceAndPath((String)"je", (String)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).getPath())));
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.IRON, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.COPPER, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.GOLD, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.EMERALD, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.LAPIS, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST, Float.valueOf(1.0f));
    }
}

