/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.je.common.block.ModBlocks;
import net.je.common.conditions.ModConfigEnabledCondition;
import net.je.common.conditions.ModNotCondition;
import net.je.common.item.ModItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.COMPRESSED_END_STONE.get())).pattern("AAA").pattern("AAA").pattern("AAA").define(Character.valueOf('A'), (ItemLike)Blocks.END_STONE).unlockedBy("has_end_stone", ModRecipeProvider.has((ItemLike)Blocks.END_STONE)).save(recipeOutput);
        ConditionalRecipe.builder().condition((ICondition)new ModConfigEnabledCondition("vanilla_eye_recipe_enabled")).recipe(consumer -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.ENDER_EYE).requires((ItemLike)Items.ENDER_PEARL).requires((ItemLike)Items.BLAZE_POWDER).unlockedBy("has_ender_pearl", ModRecipeProvider.has((ItemLike)Items.ENDER_PEARL)).save(consumer)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"je", (String)"mod_ender_eye"));
        ConditionalRecipe.builder().condition((ICondition)new ModConfigEnabledCondition("eye_requires_echo_shards")).recipe(consumer -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.ENDER_EYE).requires((ItemLike)ModItems.EYE_FRAGMENT.get()).requires((ItemLike)Items.BLAZE_POWDER).requires((ItemLike)Items.ECHO_SHARD).unlockedBy("has_eye_fragment", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.EYE_FRAGMENT.get()))).save(consumer)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"je", (String)"je_ender_eye_with_echo_shard"));
        ConditionalRecipe.builder().condition((ICondition)new ModNotCondition(new ModConfigEnabledCondition("eye_requires_echo_shards"))).recipe(consumer -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.ENDER_EYE).requires((ItemLike)ModItems.EYE_FRAGMENT.get()).requires((ItemLike)Items.BLAZE_POWDER).unlockedBy("has_eye_fragment", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.EYE_FRAGMENT.get()))).save(consumer)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"je", (String)"je_ender_eye_without_echo_shard"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.END_STONE_FURNACE.get())).pattern("AAA").pattern("ABA").pattern("AAA").define(Character.valueOf('A'), (ItemLike)ModBlocks.COMPRESSED_END_STONE.get()).define(Character.valueOf('B'), (ItemLike)Blocks.BLAST_FURNACE).unlockedBy("has_compressed_end_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.COMPRESSED_END_STONE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.VOIDMETAL_BLOCK.get())).pattern("AAA").pattern("AAA").pattern("AAA").define(Character.valueOf('A'), (ItemLike)ModItems.VOIDMETAL_INGOT.get()).unlockedBy("has_voidmetal", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.VOIDMETAL_INGOT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.VOIDMETAL_UPGRADE_SMITHING_TEMPLATE.get()), (int)2).pattern("ACA").pattern("ABA").pattern("AAA").define(Character.valueOf('A'), (ItemLike)Items.DIAMOND).define(Character.valueOf('B'), (ItemLike)Blocks.END_STONE).define(Character.valueOf('C'), (ItemLike)ModItems.VOIDMETAL_UPGRADE_SMITHING_TEMPLATE.get()).unlockedBy("has_voidmetal_upgrade", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.VOIDMETAL_UPGRADE_SMITHING_TEMPLATE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.INTERDIMENSIONAL_ANCHOR.get()), (int)1).pattern("ABA").pattern("BCB").pattern("ABA").define(Character.valueOf('A'), (ItemLike)ModItems.VOIDMETAL_INGOT.get()).define(Character.valueOf('B'), (ItemLike)Items.NETHERITE_INGOT).define(Character.valueOf('C'), (ItemLike)Items.NETHER_STAR).unlockedBy("has_voidmetal", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.VOIDMETAL_INGOT.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.VOIDMETAL_INGOT.get()), (int)9).requires((ItemLike)ModBlocks.VOIDMETAL_BLOCK.get()).unlockedBy("has_voidmetal_block", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.VOIDMETAL_BLOCK.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.VOIDMETAL_NUGGET.get()), (int)9).requires((ItemLike)ModItems.VOIDMETAL_INGOT.get()).unlockedBy("has_voidmetal_ingot_for_nuggets", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.VOIDMETAL_INGOT.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.TIMEWORN_JOURNAL_T0.get()), (int)1).requires((ItemLike)Items.ENDER_PEARL).requires((ItemLike)Items.BOOK).unlockedBy("has_cobblestone", ModRecipeProvider.has((ItemLike)Items.COBBLESTONE)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.TIMEWORN_JOURNAL_T1.get()), (int)1).requires((ItemLike)Blocks.END_STONE).requires((ItemLike)ModItems.TIMEWORN_JOURNAL_T0.get()).unlockedBy("has_end_stone", ModRecipeProvider.has((ItemLike)Blocks.END_STONE)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.TIMEWORN_JOURNAL_T2.get()), (int)1).requires((ItemLike)ModItems.VOIDMETAL_INGOT.get()).requires((ItemLike)ModItems.TIMEWORN_JOURNAL_T1.get()).unlockedBy("has_voidmetal_ingot", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.VOIDMETAL_INGOT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SHADOW_AMULET.get()), (int)1).pattern("CVC").pattern("VNV").pattern(" V ").define(Character.valueOf('C'), (ItemLike)Blocks.CHAIN).define(Character.valueOf('V'), (ItemLike)ModItems.VOIDMETAL_INGOT.get()).define(Character.valueOf('N'), (ItemLike)Items.NETHER_STAR).unlockedBy("has_voidmetal", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.VOIDMETAL_INGOT.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE.get()), (int)1).requires((ItemLike)ModBlocks.WARDED_SHADOW_STONE.get()).unlockedBy("has_warded_shadow_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.WARDED_SHADOW_STONE.get()))).save(recipeOutput, "shadow_stone_from_warded");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICKS.get()), (int)1).requires((ItemLike)ModBlocks.WARDED_SHADOW_STONE_BRICKS.get()).unlockedBy("has_warded_shadow_stone_bricks", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.WARDED_SHADOW_STONE_BRICKS.get()))).save(recipeOutput, "shadow_stone_bricks_from_warded");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CRACKED_SHADOW_STONE_BRICKS.get()), (int)1).requires((ItemLike)ModBlocks.WARDED_CRACKED_SHADOW_STONE_BRICKS.get()).unlockedBy("has_warded_cracked_shadow_stone_bricks", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.WARDED_CRACKED_SHADOW_STONE_BRICKS.get()))).save(recipeOutput, "cracked_shadow_stone_bricks_from_warded");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CRACKED_SHADOW_STONE_BRICKS.get()), (int)1).requires((ItemLike)ModBlocks.FRACTURED_WARDSTONE.get()).unlockedBy("has_warded_fractured_wardstone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.FRACTURED_WARDSTONE.get()))).save(recipeOutput, "cracked_shadow_stone_bricks_from_fractured_wardstone");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()), (int)1).requires((ItemLike)ModBlocks.WARDED_POLISHED_SHADOW_STONE.get()).unlockedBy("has_warded_polished_shadow_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.WARDED_POLISHED_SHADOW_STONE.get()))).save(recipeOutput, "polished_shadow_stone_from_warded");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CORRUPTED_SHADOW_STONE.get()), (int)1).requires((ItemLike)ModBlocks.WARDED_CORRUPTED_SHADOW_STONE.get()).unlockedBy("has_warded_corrupted_shadow_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.WARDED_CORRUPTED_SHADOW_STONE.get()))).save(recipeOutput, "corrupted_shadow_stone_from_warded");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.VOID_LANTERN.get()), (int)1).requires((ItemLike)ModBlocks.WARDED_VOID_LANTERN.get()).unlockedBy("has_warded_void_lantern", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.WARDED_VOID_LANTERN.get()))).save(recipeOutput, "void_lantern_from_warded");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.FADED_END_STONE_BRICKS.get()), (int)1).requires((ItemLike)ModBlocks.WARDED_FADED_END_STONE_BRICKS.get()).unlockedBy("has_warded_faded_end_stone_bricks", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.WARDED_FADED_END_STONE_BRICKS.get()))).save(recipeOutput, "faded_end_stone_bricks_from_warded");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.BLIGHTED_SHADOW_STONE.get()), (int)1).requires((ItemLike)ModBlocks.WARDED_BLIGHTED_SHADOW_STONE.get()).unlockedBy("has_warded_blighted_shadow_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.WARDED_BLIGHTED_SHADOW_STONE.get()))).save(recipeOutput, "blighted_shadow_stone_from_warded");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CHISELED_SHADOW_STONE.get()), (int)1).requires((ItemLike)ModBlocks.WARDED_CHISELED_SHADOW_STONE.get()).unlockedBy("has_warded_chiseled_shadow_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.WARDED_CHISELED_SHADOW_STONE.get()))).save(recipeOutput, "chiseled_shadow_stone_from_warded");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.VOIDGLASS.get()), (int)1).requires((ItemLike)ModBlocks.WARDED_VOIDGLASS.get()).unlockedBy("has_warded_voidglass", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.WARDED_VOIDGLASS.get()))).save(recipeOutput, "voidglass_from_warded");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE_SLAB.get()), (int)6).pattern("AAA").define(Character.valueOf('A'), (ItemLike)ModBlocks.POLISHED_END_STONE.get()).unlockedBy("has_polished_end_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE_WALL.get()), (int)6).pattern("AAA").pattern("AAA").define(Character.valueOf('A'), (ItemLike)ModBlocks.POLISHED_END_STONE.get()).unlockedBy("has_polished_end_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE_STAIRS.get()), (int)4).pattern("A  ").pattern("AA ").pattern("AAA").define(Character.valueOf('A'), (ItemLike)ModBlocks.POLISHED_END_STONE.get()).unlockedBy("has_polished_end_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.END_STONE_TILES.get()), (int)4).pattern("AA").pattern("AA").define(Character.valueOf('A'), (ItemLike)Blocks.END_STONE_BRICKS).unlockedBy("has_end_stone_bricks", ModRecipeProvider.has((ItemLike)Blocks.END_STONE_BRICKS)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CHISELED_END_STONE.get()), (int)1).pattern("A").pattern("A").define(Character.valueOf('A'), (ItemLike)Blocks.END_STONE_BRICK_SLAB).unlockedBy("has_end_stone_bricks", ModRecipeProvider.has((ItemLike)Blocks.END_STONE_BRICKS)).save(recipeOutput, "chiseled_end_stone_from_end_brick_slab");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CHISELED_END_STONE.get()), (int)1).pattern("A").pattern("A").define(Character.valueOf('A'), (ItemLike)ModBlocks.POLISHED_END_STONE_SLAB.get()).unlockedBy("has_polished_end_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.END_STONE_BRICKS, (int)4).pattern("AA").pattern("AA").define(Character.valueOf('A'), (ItemLike)ModBlocks.POLISHED_END_STONE.get()).unlockedBy("has_polished_end_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE.get()), (int)4).pattern("AA").pattern("AA").define(Character.valueOf('A'), (ItemLike)Blocks.END_STONE).unlockedBy("has_end_stone", ModRecipeProvider.has((ItemLike)Blocks.END_STONE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.END_STONE_PILLAR.get()), (int)2).pattern("A").pattern("A").define(Character.valueOf('A'), (ItemLike)ModBlocks.POLISHED_END_STONE.get()).unlockedBy("has_polished_end_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE.get()))).save(recipeOutput);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE.get()), (ItemLike)Blocks.END_STONE);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.END_STONE_BRICKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.END_STONE_TILES.get()), (ItemLike)Blocks.END_STONE);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.END_STONE_TILES.get()), (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.END_STONE_TILES.get()), (ItemLike)Blocks.END_STONE_BRICKS);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CHISELED_END_STONE.get()), (ItemLike)Blocks.END_STONE);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CHISELED_END_STONE.get()), (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.END_STONE_PILLAR.get()), (ItemLike)Blocks.END_STONE);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.END_STONE_PILLAR.get()), (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE_SLAB.get()), (ItemLike)Blocks.END_STONE, (int)2);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE_STAIRS.get()), (ItemLike)Blocks.END_STONE);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE_WALL.get()), (ItemLike)Blocks.END_STONE);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE_SLAB.get()), (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE.get()), (int)2);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE_STAIRS.get()), (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE_WALL.get()), (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.END_STONE_BRICK_SLAB, (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE.get()), (int)2);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.END_STONE_BRICK_STAIRS, (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.END_STONE_BRICK_WALL, (ItemLike)((ItemLike)ModBlocks.POLISHED_END_STONE.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()), (int)4).pattern("AA").pattern("AA").define(Character.valueOf('A'), (ItemLike)ModBlocks.SHADOW_STONE.get()).unlockedBy("has_shadow_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.SHADOW_STONE.get()))).save(recipeOutput);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()), (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICKS.get()), (int)4).pattern("AA").pattern("AA").define(Character.valueOf('A'), (ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()).unlockedBy("has_polished_shadow_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()))).save(recipeOutput);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICKS.get()), (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICKS.get()), (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE_SLAB.get()), (int)6).pattern("AAA").define(Character.valueOf('A'), (ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()).unlockedBy("has_polished_shadow_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()))).save(recipeOutput);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE_SLAB.get()), (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE_SLAB.get()), (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE_WALL.get()), (int)6).pattern("AAA").pattern("AAA").define(Character.valueOf('A'), (ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()).unlockedBy("has_polished_shadow_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()))).save(recipeOutput);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE_WALL.get()), (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE_WALL.get()), (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE_STAIRS.get()), (int)4).pattern("A  ").pattern("AA ").pattern("AAA").define(Character.valueOf('A'), (ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()).unlockedBy("has_polished_shadow_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()))).save(recipeOutput);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE_STAIRS.get()), (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE_STAIRS.get()), (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_SLAB.get()), (int)6).pattern("AAA").define(Character.valueOf('A'), (ItemLike)ModBlocks.SHADOW_STONE.get()).unlockedBy("has_shadow_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.SHADOW_STONE.get()))).save(recipeOutput);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_SLAB.get()), (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_WALL.get()), (int)6).pattern("AAA").pattern("AAA").define(Character.valueOf('A'), (ItemLike)ModBlocks.SHADOW_STONE.get()).unlockedBy("has_shadow_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.SHADOW_STONE.get()))).save(recipeOutput);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_WALL.get()), (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_STAIRS.get()), (int)4).pattern("A  ").pattern("AA ").pattern("AAA").define(Character.valueOf('A'), (ItemLike)ModBlocks.SHADOW_STONE.get()).unlockedBy("has_shadow_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.SHADOW_STONE.get()))).save(recipeOutput);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_STAIRS.get()), (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICK_SLAB.get()), (int)6).pattern("AAA").define(Character.valueOf('A'), (ItemLike)ModBlocks.SHADOW_STONE_BRICKS.get()).unlockedBy("has_shadow_stone_bricks", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICKS.get()))).save(recipeOutput);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICK_SLAB.get()), (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICK_SLAB.get()), (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICKS.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICK_SLAB.get()), (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICK_WALL.get()), (int)6).pattern("AAA").pattern("AAA").define(Character.valueOf('A'), (ItemLike)ModBlocks.SHADOW_STONE_BRICKS.get()).unlockedBy("has_shadow_stone_bricks", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICKS.get()))).save(recipeOutput);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICK_WALL.get()), (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICK_WALL.get()), (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICKS.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICK_WALL.get()), (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICK_STAIRS.get()), (int)4).pattern("A  ").pattern("AA ").pattern("AAA").define(Character.valueOf('A'), (ItemLike)ModBlocks.SHADOW_STONE_BRICKS.get()).unlockedBy("has_shadow_stone_bricks", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICKS.get()))).save(recipeOutput);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICK_STAIRS.get()), (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICK_STAIRS.get()), (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICKS.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICK_STAIRS.get()), (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()));
        List<ItemLike> SHADOW_STONE_BRICKS_INGREDIENT = List.of((ItemLike)ModBlocks.SHADOW_STONE_BRICKS.get());
        ModRecipeProvider.oreSmelting(recipeOutput, SHADOW_STONE_BRICKS_INGREDIENT, RecipeCategory.MISC, (ItemLike)ModBlocks.CRACKED_SHADOW_STONE_BRICKS.get(), 0.25f, 200, "cracked_shadow_stone_bricks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CHISELED_SHADOW_STONE.get()), (int)1).pattern("A").pattern("A").define(Character.valueOf('A'), (ItemLike)ModBlocks.SHADOW_STONE_BRICK_SLAB.get()).unlockedBy("has_shadow_stone_bricks", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICKS.get()))).save(recipeOutput, "chiseled_shadow_stone_from_shadow_stone_bricks");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CHISELED_SHADOW_STONE.get()), (int)1).pattern("A").pattern("A").define(Character.valueOf('A'), (ItemLike)ModBlocks.POLISHED_SHADOW_STONE_SLAB.get()).unlockedBy("has_polished_shadow_stone", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()))).save(recipeOutput);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CHISELED_SHADOW_STONE.get()), (ItemLike)((ItemLike)ModBlocks.POLISHED_SHADOW_STONE.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CHISELED_SHADOW_STONE.get()), (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE_BRICKS.get()));
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CHISELED_SHADOW_STONE.get()), (ItemLike)((ItemLike)ModBlocks.SHADOW_STONE.get()));
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDMETAL_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SWORD}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDMETAL_INGOT.get()}), (RecipeCategory)RecipeCategory.MISC, (Item)((Item)ModItems.VOIDMETAL_SWORD.get())).unlocks("has_voidmetal", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.VOIDMETAL_INGOT.get()))).save(recipeOutput, "voidmetal_sword_smithing");
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDMETAL_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_PICKAXE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDMETAL_INGOT.get()}), (RecipeCategory)RecipeCategory.MISC, (Item)((Item)ModItems.VOIDMETAL_PICKAXE.get())).unlocks("has_voidmetal", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.VOIDMETAL_INGOT.get()))).save(recipeOutput, "voidmetal_pickaxe_smithing");
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDMETAL_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_AXE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDMETAL_INGOT.get()}), (RecipeCategory)RecipeCategory.MISC, (Item)((Item)ModItems.VOIDMETAL_AXE.get())).unlocks("has_voidmetal", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.VOIDMETAL_INGOT.get()))).save(recipeOutput, "voidmetal_axe_smithing");
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDMETAL_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SHOVEL}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDMETAL_INGOT.get()}), (RecipeCategory)RecipeCategory.MISC, (Item)((Item)ModItems.VOIDMETAL_SHOVEL.get())).unlocks("has_voidmetal", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.VOIDMETAL_INGOT.get()))).save(recipeOutput, "voidmetal_shovel_smithing");
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDMETAL_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_HOE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDMETAL_INGOT.get()}), (RecipeCategory)RecipeCategory.MISC, (Item)((Item)ModItems.VOIDMETAL_HOE.get())).unlocks("has_voidmetal", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.VOIDMETAL_INGOT.get()))).save(recipeOutput, "voidmetal_hoe_smithing");
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDMETAL_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_HELMET}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDMETAL_INGOT.get()}), (RecipeCategory)RecipeCategory.MISC, (Item)((Item)ModItems.VOIDMETAL_HELMET.get())).unlocks("has_voidmetal", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.VOIDMETAL_INGOT.get()))).save(recipeOutput, "voidmetal_helmet_smithing");
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDMETAL_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_CHESTPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDMETAL_INGOT.get()}), (RecipeCategory)RecipeCategory.MISC, (Item)((Item)ModItems.VOIDMETAL_CHESTPLATE.get())).unlocks("has_voidmetal", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.VOIDMETAL_INGOT.get()))).save(recipeOutput, "voidmetal_chestplate_smithing");
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDMETAL_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_LEGGINGS}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDMETAL_INGOT.get()}), (RecipeCategory)RecipeCategory.MISC, (Item)((Item)ModItems.VOIDMETAL_LEGGINGS.get())).unlocks("has_voidmetal", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.VOIDMETAL_INGOT.get()))).save(recipeOutput, "voidmetal_leggings_smithing");
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDMETAL_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_BOOTS}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.VOIDMETAL_INGOT.get()}), (RecipeCategory)RecipeCategory.MISC, (Item)((Item)ModItems.VOIDMETAL_BOOTS.get())).unlocks("has_voidmetal", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.VOIDMETAL_INGOT.get()))).save(recipeOutput, "voidmetal_boots_smithing");
    }

    protected static void oreSmelting(RecipeOutput recipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTIme, String pGroup) {
        ModRecipeProvider.oreCooking(recipeOutput, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTIme, pGroup, "_from_smelting");
    }

    protected static void oreBlasting(RecipeOutput recipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup) {
        ModRecipeProvider.oreCooking(recipeOutput, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTime, pGroup, "_from_blasting");
    }

    protected static <T extends AbstractCookingRecipe> void oreCooking(RecipeOutput recipeOutput, RecipeSerializer<T> pCookingSerializer, AbstractCookingRecipe.Factory<T> factory, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup, String pRecipeName) {
        for (ItemLike itemlike : pIngredients) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)pCategory, (ItemLike)pResult, (float)pExperience, (int)pCookingTime, pCookingSerializer, factory).group(pGroup).unlockedBy(ModRecipeProvider.getHasName((ItemLike)itemlike), ModRecipeProvider.has((ItemLike)itemlike)).save(recipeOutput, "je:" + ModRecipeProvider.getItemName((ItemLike)pResult) + pRecipeName + "_" + ModRecipeProvider.getItemName((ItemLike)itemlike));
        }
    }
}

