/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.entity.ai;

import net.je.common.entity.custom.BaseEndersent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class EndersentAttackGoal
extends MeleeAttackGoal {
    private final int ATTACK_RANGE = 4;
    private final BaseEndersent entity;
    private int attackDelay = 10;
    private int ticksUntilNextAttack = 40;
    private boolean shouldCountTillNextAttack = false;

    public EndersentAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.entity = (BaseEndersent)pMob;
    }

    public void start() {
        super.start();
        this.attackDelay = 10;
        this.ticksUntilNextAttack = 40;
    }

    protected void checkAndPerformAttack(LivingEntity pEnemy) {
        if (!this.entity.isLargeAttacking() && this.entity.canAttack) {
            if (this.isEnemyWithinAttackDistance(pEnemy)) {
                this.shouldCountTillNextAttack = true;
                if (this.isTimeToStartAttackAnimation()) {
                    this.entity.setAttacking(true);
                }
                if (this.isTimeToAttack()) {
                    this.mob.getLookControl().setLookAt(pEnemy.getX(), pEnemy.getEyeY(), pEnemy.getZ());
                    this.performAttack(pEnemy);
                }
            } else {
                this.resetAttackCooldown();
                this.shouldCountTillNextAttack = false;
                this.entity.setAttacking(false);
                this.entity.attackAnimationTimeout = 0;
            }
        }
    }

    private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy) {
        int diffZ;
        int diffY;
        int diffX = Math.abs(pEnemy.getBlockX() - this.entity.getBlockX());
        return diffX + (diffY = Math.abs(pEnemy.getBlockY() - this.entity.getBlockY())) + (diffZ = Math.abs(pEnemy.getBlockZ() - this.entity.getBlockZ())) <= this.ATTACK_RANGE;
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(this.attackDelay);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack <= this.attackDelay;
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected void performAttack(LivingEntity pEnemy) {
        this.resetAttackCooldown();
        this.mob.swing(InteractionHand.MAIN_HAND);
        this.mob.doHurtTarget((Entity)pEnemy);
    }

    public void tick() {
        super.tick();
        if (this.shouldCountTillNextAttack) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
    }

    public void stop() {
        this.entity.setAttacking(false);
        super.stop();
    }
}

