/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.entity.ai;

import net.je.common.entity.custom.BaseEndersent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class EndersentLargeAttackGoal
extends MeleeAttackGoal {
    private final int ATTACK_RANGE = 7;
    private final BaseEndersent entity;
    private int attackDelay = 20;
    private int ticksUntilNextAttack = 100;
    private boolean shouldCountTillNextAttack = false;

    public EndersentLargeAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.entity = (BaseEndersent)pMob;
    }

    public void start() {
        super.start();
        this.attackDelay = 20;
        this.ticksUntilNextAttack = 100;
    }

    protected void checkAndPerformAttack(LivingEntity pEnemy) {
        if (this.entity.canAttack && !this.entity.isAttacking() && this.entity.largeAttackCooldown <= 0) {
            if (this.isEnemyWithinAttackDistance(pEnemy)) {
                this.shouldCountTillNextAttack = true;
                if (this.isTimeToStartAttackAnimation()) {
                    this.entity.setLargeAttacking(true);
                }
                if (this.isTimeToAttack()) {
                    this.mob.getLookControl().setLookAt(pEnemy.getX(), pEnemy.getEyeY(), pEnemy.getZ());
                    this.performAttack(pEnemy);
                }
            } else {
                this.resetAttackCooldown();
                this.shouldCountTillNextAttack = false;
                this.entity.setLargeAttacking(false);
                this.entity.largeAttackAnimationTimeout = 0;
            }
        }
    }

    private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy) {
        int diffZ;
        int diffY;
        int diffX = Math.abs(pEnemy.getBlockX() - this.entity.getBlockX());
        return diffX + (diffY = Math.abs(pEnemy.getBlockY() - this.entity.getBlockY())) + (diffZ = Math.abs(pEnemy.getBlockZ() - this.entity.getBlockZ())) <= this.ATTACK_RANGE;
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(this.attackDelay);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack <= this.attackDelay;
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected void performAttack(LivingEntity pEnemy) {
        this.resetAttackCooldown();
        this.mob.swing(InteractionHand.MAIN_HAND);
        this.endersentHurtTarget((Entity)pEnemy);
        this.entity.largeAttackCooldown = 140;
        this.entity.goalSelector.removeGoal(this.entity.endersentLargeAttackGoal);
    }

    public boolean endersentHurtTarget(Entity p_21372_) {
        DamageSource damagesource = this.entity.damageSources().mobAttack((LivingEntity)this.entity);
        boolean flag = p_21372_.hurt(damagesource, 15.0f);
        if (flag) {
            float f1 = 30.0f;
            if (f1 > 0.0f && p_21372_ instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)p_21372_;
                livingentity.knockback((double)(f1 * 0.5f), (double)Mth.sin((float)(this.entity.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.entity.getYRot() * ((float)Math.PI / 180)))));
                this.entity.setDeltaMovement(this.entity.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            this.entity.setLastHurtMob(p_21372_);
            this.entity.playAttackSound();
        }
        return flag;
    }

    public void tick() {
        super.tick();
        if (this.shouldCountTillNextAttack) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
    }

    public void stop() {
        this.entity.setLargeAttacking(false);
        super.stop();
    }
}

