/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.entity.client;

import net.je.common.entity.animations.EndersentAnim;
import net.je.common.entity.animations.EndersentAttackAnim;
import net.je.common.entity.custom.BaseEndersent;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EndersentModel<T extends Entity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation ENDERSENT_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"je", (String)"endersent"), "main");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftArm;
    private final ModelPart leftArm2;
    private final ModelPart rightArm;
    private final ModelPart rightArm2;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public EndersentModel(ModelPart root) {
        this.root = root.getChild("root");
        this.body = this.root.getChild("body");
        this.head = this.root.getChild("head");
        this.leftArm = this.root.getChild("leftArm");
        this.leftArm2 = this.leftArm.getChild("leftArm2");
        this.rightArm = this.root.getChild("rightArm");
        this.rightArm2 = this.rightArm.getChild("rightArm2");
        this.rightLeg = this.root.getChild("rightLeg");
        this.leftLeg = this.root.getChild("leftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-20.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-12.0f, -19.0f, -7.0f, 24.0f, 28.0f, 14.0f, new CubeDeformation(0.0f)).texOffs(0, 120).addBox(-6.5f, -10.0f, -7.01f, 13.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-9.0f, (float)0.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(48, 70).addBox(-8.0f, -13.0f, -8.0f, 16.0f, 18.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-26.0f, (float)-5.0f));
        PartDefinition leftArm = root.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(15, 0).addBox(0.0f, -2.0f, -3.0f, 6.0f, 34.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)12.0f, (float)-22.0f, (float)0.0f));
        PartDefinition leftArm2 = leftArm.addOrReplaceChild("leftArm2", CubeListBuilder.create().texOffs(15, 0).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 34.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 13).addBox(-4.0f, 22.0f, -3.0f, 8.0f, 12.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)32.0f, (float)0.0f));
        PartDefinition rightArm = root.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(15, 0).addBox(-6.0f, -2.0f, -3.0f, 6.0f, 34.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-12.0f, (float)-22.0f, (float)0.0f));
        PartDefinition rightArm2 = rightArm.addOrReplaceChild("rightArm2", CubeListBuilder.create().texOffs(15, 0).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 34.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 13).addBox(-4.0f, 22.0f, -3.0f, 8.0f, 12.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)32.0f, (float)0.0f));
        PartDefinition rightLeg = root.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(24, 70).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 44.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = root.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(0, 70).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 44.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T p_102618_, float p_102619_, float p_102620_, float p_102621_, float p_102622_, float p_102623_) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.xRot = p_102623_ * ((float)Math.PI / 180);
        this.head.yRot = p_102622_ * ((float)Math.PI / 180);
        this.animateWalk(EndersentAnim.WALK, p_102619_, p_102620_, 2.0f, 2.5f);
        this.animate(((BaseEndersent)((Object)p_102618_)).attackAnimationState, EndersentAttackAnim.ATTACK, p_102621_, 1.0f);
        this.animate(((BaseEndersent)((Object)p_102618_)).largeAttackAnimationState, EndersentAttackAnim.LARGE_ATTACK, p_102621_, 1.0f);
    }
}

