/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.entity.custom;

import net.je.common.entity.ai.EndersentLargeAttackGoal;
import net.je.common.sound.ModSounds;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;

public class BaseEndersent
extends Monster {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.defineId(BaseEndersent.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LARGE_ATTACKING = SynchedEntityData.defineId(BaseEndersent.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState largeAttackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    public int largeAttackAnimationTimeout = 0;
    public Goal endersentLargeAttackGoal = new EndersentLargeAttackGoal((PathfinderMob)this, 1.0, true);
    public boolean canAttack = true;
    public int largeAttackCooldown = 140;

    public BaseEndersent(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_333664_) {
        super.defineSynchedData(p_333664_);
        p_333664_.define(ATTACKING, (Object)false);
        p_333664_.define(LARGE_ATTACKING, (Object)false);
    }

    public void setAttacking(boolean attacking) {
        this.entityData.set(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(ATTACKING);
    }

    public void setLargeAttacking(boolean attacking) {
        this.entityData.set(LARGE_ATTACKING, (Object)attacking);
    }

    public boolean isLargeAttacking() {
        return (Boolean)this.entityData.get(LARGE_ATTACKING);
    }

    protected void setupAnimationStates() {
        if (this.isAttacking() && this.attackAnimationTimeout <= 0 && !this.isLargeAttacking()) {
            this.attackAnimationTimeout = 10;
            this.attackAnimationState.start(this.tickCount);
        } else {
            --this.attackAnimationTimeout;
        }
        if (this.isLargeAttacking() && this.largeAttackAnimationTimeout <= 0 && !this.isAttacking()) {
            this.largeAttackAnimationTimeout = 20;
            this.largeAttackAnimationState.start(this.tickCount);
        } else {
            --this.largeAttackAnimationTimeout;
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.stop();
        }
        if (!this.isLargeAttacking()) {
            this.largeAttackAnimationState.stop();
        }
    }

    protected void defaultTick() {
        super.tick();
    }

    public void playAttackSound() {
        this.playSound((SoundEvent)ModSounds.ENDERSENT_STEP.get(), 5.0f, 1.0f);
    }

    public void tick() {
        this.defaultTick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        --this.largeAttackCooldown;
        if (this.largeAttackCooldown <= 0) {
            this.goalSelector.addGoal(1, this.endersentLargeAttackGoal);
        }
    }
}

