/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.entity.custom;

import net.je.common.entity.ai.ShadowMobNavigation;
import net.je.common.entity.animations.DuskbladeAnim;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class Duskblade
extends Monster {
    public static final int ATTACK_1_DURATION = (int)(DuskbladeAnim.ATTACK_1.lengthInSeconds() * 20.0f);
    public static final int ATTACK_2_DURATION = (int)(DuskbladeAnim.ATTACK_2.lengthInSeconds() * 20.0f);
    public static final int ATTACK_3_DURATION = (int)(DuskbladeAnim.ATTACK_3.lengthInSeconds() * 20.0f);
    public final AnimationState attackAnimationState = new AnimationState();
    private int currentAttack = 0;
    private int attackTick = 0;
    private int attackDuration = 0;

    public Duskblade(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void startAttack() {
        this.currentAttack = this.currentAttack % 3 + 1;
        this.attackTick = 1;
        this.attackDuration = switch (this.currentAttack) {
            case 1 -> ATTACK_1_DURATION;
            case 2 -> ATTACK_2_DURATION;
            case 3 -> ATTACK_3_DURATION;
            default -> 0;
        };
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        if (this.attackTick > 0) {
            ++this.attackTick;
            if (this.attackTick > this.attackDuration) {
                this.attackTick = 0;
                this.attackDuration = 0;
            }
        }
    }

    public int getCurrentAttack() {
        return this.currentAttack;
    }

    public int getAttackTick() {
        return this.attackTick;
    }

    public boolean doHurtTarget(Entity pEntity) {
        this.startAttack();
        return super.doHurtTarget(pEntity);
    }

    public static AttributeSupplier.Builder createMonsterAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 10.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, false));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
    }

    protected void setupAnimationStates() {
        if (this.attackTick > 0) {
            this.attackAnimationState.start(this.tickCount);
        }
        if (this.attackTick <= 0) {
            this.attackAnimationState.stop();
        }
    }

    protected PathNavigation createNavigation(Level level) {
        return new ShadowMobNavigation((Mob)this, level);
    }
}

