/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.entity.custom;

import net.je.common.entity.ai.ShadowMobNavigation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class Echo
extends Monster {
    private boolean didHaveSword = false;
    public static final TagKey<Item> SWORDS_TAG = ItemTags.create((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"swords"));

    public Echo(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createMonsterAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 10.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, false));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
    }

    public void setTarget(@Nullable LivingEntity target) {
        super.setTarget(target);
        if (target instanceof Player) {
            Player player = (Player)target;
            ItemStack mainHand = player.getItemBySlot(EquipmentSlot.MAINHAND);
            if (!mainHand.isEmpty() && mainHand.is(SWORDS_TAG)) {
                ItemStack copy = new ItemStack((ItemLike)mainHand.getItem(), 1);
                this.setItemSlot(EquipmentSlot.MAINHAND, copy);
                this.didHaveSword = true;
            }
            if (!mainHand.is(SWORDS_TAG) && this.didHaveSword) {
                this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            }
        }
    }

    public void die(DamageSource pDamageSource) {
        this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        super.die(pDamageSource);
    }

    protected PathNavigation createNavigation(Level level) {
        return new ShadowMobNavigation((Mob)this, level);
    }
}

