/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.entity.custom;

import net.je.common.block.ModBlocks;
import net.je.common.block.custom.WardedBlock;
import net.je.common.entity.ModEntities;
import net.je.common.entity.custom.Echo;
import net.je.common.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class ShadowLord
extends Monster {
    private final ServerBossEvent bossEvent = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    private static final EntityDataAccessor<Boolean> AWAKE = SynchedEntityData.defineId(ShadowLord.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<BlockPos> ARENA_CENTER = SynchedEntityData.defineId(ShadowLord.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);

    public ShadowLord(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setNoAi(true);
        this.setPersistenceRequired();
        this.setRemainingFireTicks(0);
        this.fireImmune();
    }

    public static AttributeSupplier.Builder createMonsterAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 0.5).add(Attributes.MAX_HEALTH, 400.0).add(Attributes.FOLLOW_RANGE, 15.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0);
    }

    public void die(DamageSource pDamageSource) {
        super.die(pDamageSource);
        if (!this.level().isClientSide()) {
            AABB area = this.getBoundingBox().inflate(10.0);
            for (Echo echo : this.level().getEntitiesOfClass(Echo.class, area)) {
                if (!(this.distanceToSqr((Entity)echo) <= 100.0)) continue;
                echo.kill();
            }
        }
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void checkDespawn() {
    }

    public boolean shouldDespawnInPeaceful() {
        return false;
    }

    public boolean isPushable() {
        return this.isAwake();
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean isAwake() {
        return (Boolean)this.entityData.get(AWAKE);
    }

    public void setCustomName(@javax.annotation.Nullable Component pName) {
        super.setCustomName(pName);
        if (this.isAwake()) {
            this.bossEvent.setName(this.getDisplayName());
        }
    }

    public void startSeenByPlayer(ServerPlayer pPlayer) {
        super.startSeenByPlayer(pPlayer);
        if (this.isAwake()) {
            this.bossEvent.addPlayer(pPlayer);
        }
    }

    public void stopSeenByPlayer(ServerPlayer pPlayer) {
        super.stopSeenByPlayer(pPlayer);
        this.bossEvent.removePlayer(pPlayer);
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.isAwake()) {
            this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
        }
    }

    public void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (this.isAwake()) {
            super.setTarget(target);
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.SHADOW_STEEL_SWORD.get()));
        }
    }

    public void tick() {
        super.tick();
        if (this.level() != null && !this.level().isClientSide()) {
            Level level = this.level();
            if (level.getGameTime() % 60L == 0L && this.getTarget() != null) {
                this.tryTeleport();
            }
            if (level.getGameTime() % 10L == 0L && this.getTarget() != null) {
                if ((double)(this.getHealth() / this.getMaxHealth()) > 0.66) {
                    this.addLaser(this.findLaserPos(), level);
                } else if ((double)(this.getHealth() / this.getMaxHealth()) > 0.33) {
                    this.addLaser(this.findLaserPos(), level);
                    this.addLaser(this.findLaserPos(), level);
                } else {
                    this.addLaser(this.findLaserPos(), level);
                    this.addLaser(this.findLaserPos(), level);
                    this.addLaser(this.findLaserPos(), level);
                    this.addLaser(this.findLaserPos(), level);
                    if (level.getGameTime() % 100L == 0L) {
                        Entity entity = ((EntityType)ModEntities.ECHO.get()).create(level);
                        entity.moveTo(this.position());
                        level.addFreshEntity(entity);
                    }
                }
            }
            if (this.getArenaCenter() != null && this.getY() < (double)(this.getArenaCenter().getY() - 3)) {
                this.tryTeleport();
            }
        }
    }

    public BlockPos findLaserPos() {
        BlockPos pos = this.getOnPos();
        int x = this.random.nextInt(5) + -2;
        int z = this.random.nextInt(5) + -2;
        BlockPos laserPos = pos.offset(x, 0, z);
        return laserPos;
    }

    public void addLaser(BlockPos laserPos, Level level) {
        if (!level.getBlockState(laserPos).is((Block)ModBlocks.UNSTABLE_SHADOW_PRISM.get()) && level.getBlockState(laserPos).is((Block)ModBlocks.WARDED_FADED_END_STONE_BRICKS.get()) && level.isEmptyBlock(laserPos.above())) {
            level.setBlockAndUpdate(laserPos, ((Block)ModBlocks.UNSTABLE_SHADOW_PRISM.get()).defaultBlockState());
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean result = super.hurt(source, amount);
        if (!this.level().isClientSide && this.isAwake() && this.horizontalCollision) {
            this.tryTeleport();
        }
        return result;
    }

    private void tryTeleport() {
        ServerLevel serverLevel = (ServerLevel)this.level();
        for (int i = 0; i < 10; ++i) {
            double dz;
            double dy;
            double dx = this.getArenaCenter().getX() + (this.random.nextInt(16) - 8);
            BlockPos pos = BlockPos.containing((double)dx, (double)(dy = (double)this.getArenaCenter().getY()), (double)(dz = (double)(this.getArenaCenter().getZ() + (this.random.nextInt(16) - 8))));
            if (!serverLevel.getBlockState(pos.below()).is((Block)ModBlocks.WARDED_FADED_END_STONE_BRICKS.get()) || !this.randomTeleport(dx, dy, dz, true)) continue;
            serverLevel.playSound(null, this.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.HOSTILE, 1.0f, 1.0f);
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.PORTAL, this.getX(), this.getY() + 1.0, this.getZ(), 20, 0.5, 0.5, 0.5, 0.02);
            break;
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!this.level().isClientSide && !this.isAwake()) {
            this.entityData.set(AWAKE, (Object)true);
            this.setArenaCenter(this.blockPosition());
            this.replaceShadowPrismCircle((ServerLevel)this.level(), this.blockPosition().below(), 3);
            this.setNoAi(false);
            if (!player.isCreative()) {
                if (player instanceof ServerPlayer) {
                    this.setTarget((LivingEntity)player);
                } else {
                    this.setTarget((LivingEntity)player);
                }
            }
            for (ServerPlayer pPlayer : ((ServerLevel)this.level()).players()) {
                if (!(this.distanceToSqr((Entity)pPlayer) < 16.0)) continue;
                this.bossEvent.addPlayer(pPlayer);
            }
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 1.0, this.getZ(), 20, 0.5, 0.5, 0.5, 0.02);
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(player, hand);
    }

    private void replaceShadowPrismCircle(ServerLevel level, BlockPos center, int radius) {
        int rSq = radius * radius;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos pos;
                if (dx * dx + dz * dz > rSq || !level.getBlockState(pos = center.offset(dx, 0, dz)).is((Block)ModBlocks.SHADOW_PRISM.get())) continue;
                level.setBlock(pos, (BlockState)((Block)ModBlocks.WARDED_FADED_END_STONE_BRICKS.get()).defaultBlockState().setValue((Property)WardedBlock.PLACED, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (!this.isAwake()) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("Awake", this.isAwake());
        BlockPos pos = this.getArenaCenter();
        nbt.putInt("ArenaX", pos.getX());
        nbt.putInt("ArenaY", pos.getY());
        nbt.putInt("ArenaZ", pos.getZ());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        boolean w = nbt.getBoolean("Awake");
        this.entityData.set(AWAKE, (Object)w);
        this.setNoAi(!w);
        if (nbt.contains("ArenaX")) {
            this.setArenaCenter(new BlockPos(nbt.getInt("ArenaX"), nbt.getInt("ArenaY"), nbt.getInt("ArenaZ")));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_333664_) {
        super.defineSynchedData(p_333664_);
        p_333664_.define(AWAKE, (Object)false);
        p_333664_.define(ARENA_CENTER, (Object)BlockPos.ZERO);
    }

    public void setArenaCenter(BlockPos pos) {
        this.entityData.set(ARENA_CENTER, (Object)pos);
    }

    @Nullable
    public BlockPos getArenaCenter() {
        return (BlockPos)this.entityData.get(ARENA_CENTER);
    }
}

