/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.fluid;

import java.util.List;
import net.je.common.effect.ModEffects;
import net.je.common.fluid.ModFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public abstract class VoidblightFluid
extends ForgeFlowingFluid {
    private VoidblightFluid() {
        super(ModFluids.VOIDBLIGHT_PROPERTIES);
    }

    public void tick(Level pLevel, BlockPos pPos, FluidState pState) {
        super.tick(pLevel, pPos, pState);
        AABB box = new AABB(pPos);
        List entities = pLevel.getEntitiesOfClass(LivingEntity.class, box);
        Holder holder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)ModEffects.VOID_STRIKE_EFFECT.get()));
        for (LivingEntity entity : entities) {
            entity.addEffect(new MobEffectInstance(holder, 60, 1));
        }
        pLevel.scheduleTick(pPos, (Fluid)this, 10);
    }

    public static class Source
    extends VoidblightFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends VoidblightFluid {
        public Flowing() {
            this.registerDefaultState((FluidState)((FluidState)this.getStateDefinition().any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(7)));
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }
}

