/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.je.common.block.entity.ShadowPrismBlockEntity;
import net.je.common.render.ModRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class ShadowPrismRenderer<T extends ShadowPrismBlockEntity>
implements BlockEntityRenderer<T> {
    public static final ResourceLocation END_SKY_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/block/shadow_prism_bg.png");
    public static final ResourceLocation END_PORTAL_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/end_portal.png");

    public ShadowPrismRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public void render(T pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Matrix4f matrix4f = pPoseStack.last().pose();
        this.renderCube(pBlockEntity, matrix4f, pBufferSource.getBuffer(this.renderType()));
    }

    private void renderCube(T pBlockEntity, Matrix4f pPose, VertexConsumer pConsumer) {
        float f = this.getOffsetDown();
        float f1 = this.getOffsetUp();
        this.renderFace(pBlockEntity, pPose, pConsumer, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, Direction.SOUTH);
        this.renderFace(pBlockEntity, pPose, pConsumer, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Direction.NORTH);
        this.renderFace(pBlockEntity, pPose, pConsumer, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, Direction.EAST);
        this.renderFace(pBlockEntity, pPose, pConsumer, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, Direction.WEST);
        this.renderFace(pBlockEntity, pPose, pConsumer, 0.0f, 1.0f, f, f, 0.0f, 0.0f, 1.0f, 1.0f, Direction.DOWN);
        this.renderFace(pBlockEntity, pPose, pConsumer, 0.0f, 1.0f, f1, f1, 1.0f, 1.0f, 0.0f, 0.0f, Direction.UP);
    }

    private void renderFace(T pBlockEntity, Matrix4f pPose, VertexConsumer pConsumer, float pX0, float pX1, float pY0, float pY1, float pZ0, float pZ1, float pZ2, float pZ3, Direction pDirection) {
        if (((ShadowPrismBlockEntity)((Object)pBlockEntity)).shouldRenderFace(pDirection)) {
            pConsumer.addVertex(pPose, pX0, pY0, pZ0);
            pConsumer.addVertex(pPose, pX1, pY0, pZ1);
            pConsumer.addVertex(pPose, pX1, pY1, pZ2);
            pConsumer.addVertex(pPose, pX0, pY1, pZ3);
        }
    }

    protected float getOffsetUp() {
        return 1.0f;
    }

    protected float getOffsetDown() {
        return 0.0f;
    }

    protected RenderType renderType() {
        return ModRenderTypes.SHADOW_PRISM;
    }
}

