/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.je.common.block.entity.UnstableShadowPrismBlockEntity;
import net.je.common.render.ModRenderTypes;
import net.je.common.render.ShadowPrismRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.phys.Vec3;

public class UnstableShadowPrismRenderer
extends ShadowPrismRenderer<UnstableShadowPrismBlockEntity> {
    public static final ResourceLocation BEAM_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/beacon_beam.png");
    public static final int MAX_RENDER_Y = 1024;

    public UnstableShadowPrismRenderer(BlockEntityRendererProvider.Context pContext) {
        super(pContext);
    }

    @Override
    public void render(UnstableShadowPrismBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        int j = DyeColor.WHITE.getTextureDiffuseColor();
        long k = pBlockEntity.getLevel().getGameTime();
        if (pBlockEntity.isActive()) {
            UnstableShadowPrismRenderer.renderBeaconBeam(pPoseStack, pBufferSource, BEAM_LOCATION, pPartialTick, 1.0f, k, 1, 6, j, 0.15f, 0.175f);
        }
        super.render(pBlockEntity, pPartialTick, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay);
    }

    public static void renderBeaconBeam(PoseStack pPoseStack, MultiBufferSource pBufferSource, ResourceLocation pBeamLocation, float pPartialTick, float pTextureScale, long pGameTime, int pYOffset, int pHeight, int pColor, float pBeamRadius, float pGlowRadius) {
        int i = pYOffset + pHeight;
        pPoseStack.pushPose();
        pPoseStack.translate(0.5, 0.0, 0.5);
        float f = (float)Math.floorMod(pGameTime, 40) + pPartialTick;
        float f1 = pHeight < 0 ? f : -f;
        float f2 = Mth.frac((float)(f1 * 0.2f - (float)Mth.floor((float)(f1 * 0.1f))));
        pPoseStack.pushPose();
        pPoseStack.mulPose(Axis.YP.rotationDegrees(f * 2.25f - 45.0f));
        float f3 = 0.0f;
        float f5 = 0.0f;
        float f6 = -pBeamRadius;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = -pBeamRadius;
        float f10 = 0.0f;
        float f11 = 1.0f;
        float f12 = -1.0f + f2;
        float f13 = (float)pHeight * pTextureScale * (0.5f / pBeamRadius) + f12;
        UnstableShadowPrismRenderer.renderPart(pPoseStack, pBufferSource.getBuffer(ModRenderTypes.SHADOW_PRISM), pColor, pYOffset, i, 0.0f, pBeamRadius, pBeamRadius, 0.0f, f6, 0.0f, 0.0f, f9, 0.0f, 1.0f, f13, f12);
        pPoseStack.popPose();
        f3 = -pGlowRadius;
        float f4 = -pGlowRadius;
        f5 = -pGlowRadius;
        f6 = -pGlowRadius;
        f10 = 0.0f;
        f11 = 1.0f;
        f12 = -1.0f + f2;
        f13 = (float)pHeight * pTextureScale + f12;
        UnstableShadowPrismRenderer.renderPart(pPoseStack, pBufferSource.getBuffer(RenderType.beaconBeam((ResourceLocation)pBeamLocation, (boolean)true)), FastColor.ARGB32.color((int)32, (int)pColor), pYOffset, i, f3, f4, pGlowRadius, f5, f6, pGlowRadius, pGlowRadius, pGlowRadius, 0.0f, 1.0f, f13, f12);
        pPoseStack.popPose();
    }

    private static void renderPart(PoseStack pPoseStack, VertexConsumer pConsumer, int pColor, int pMinY, int pMaxY, float pX1, float pZ1, float pX2, float pZ2, float pX3, float pZ3, float pX4, float pZ4, float pMinU, float pMaxU, float pMinV, float pMaxV) {
        PoseStack.Pose posestack$pose = pPoseStack.last();
        UnstableShadowPrismRenderer.renderQuad(posestack$pose, pConsumer, pColor, pMinY, pMaxY, pX1, pZ1, pX2, pZ2, pMinU, pMaxU, pMinV, pMaxV);
        UnstableShadowPrismRenderer.renderQuad(posestack$pose, pConsumer, pColor, pMinY, pMaxY, pX4, pZ4, pX3, pZ3, pMinU, pMaxU, pMinV, pMaxV);
        UnstableShadowPrismRenderer.renderQuad(posestack$pose, pConsumer, pColor, pMinY, pMaxY, pX2, pZ2, pX4, pZ4, pMinU, pMaxU, pMinV, pMaxV);
        UnstableShadowPrismRenderer.renderQuad(posestack$pose, pConsumer, pColor, pMinY, pMaxY, pX3, pZ3, pX1, pZ1, pMinU, pMaxU, pMinV, pMaxV);
    }

    private static void renderQuad(PoseStack.Pose pPose, VertexConsumer pConsumer, int pColor, int pMinY, int pMaxY, float pMinX, float pMinZ, float pMaxX, float pMaxZ, float pMinU, float pMaxU, float pMinV, float pMaxV) {
        UnstableShadowPrismRenderer.addVertex(pPose, pConsumer, pColor, pMaxY, pMinX, pMinZ, pMaxU, pMinV);
        UnstableShadowPrismRenderer.addVertex(pPose, pConsumer, pColor, pMinY, pMinX, pMinZ, pMaxU, pMaxV);
        UnstableShadowPrismRenderer.addVertex(pPose, pConsumer, pColor, pMinY, pMaxX, pMaxZ, pMinU, pMaxV);
        UnstableShadowPrismRenderer.addVertex(pPose, pConsumer, pColor, pMaxY, pMaxX, pMaxZ, pMinU, pMinV);
    }

    private static void addVertex(PoseStack.Pose pPose, VertexConsumer pConsumer, int pColor, int pY, float pX, float pZ, float pU, float pV) {
        pConsumer.addVertex(pPose, pX, (float)pY, pZ).setColor(pColor).setUv(pU, pV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pPose, 0.0f, 1.0f, 0.0f);
    }

    public boolean shouldRenderOffScreen(BeaconBlockEntity pBlockEntity) {
        return true;
    }

    public int getViewDistance() {
        return 256;
    }

    public boolean shouldRender(BeaconBlockEntity pBlockEntity, Vec3 pCameraPos) {
        return Vec3.atCenterOf((Vec3i)pBlockEntity.getBlockPos()).multiply(1.0, 0.0, 1.0).closerThan((Position)pCameraPos.multiply(1.0, 0.0, 1.0), (double)this.getViewDistance());
    }
}

