/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.screen.timeworn_journal;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class BaseTimewornJournalScreen
extends Screen {
    public static final ResourceLocation BG_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/gui/timeworn_journal_bg.png");
    private int bgStartX;
    private int bgStartY;
    private int bookWidth;
    private int bookHeight;
    private int centerX;
    private int centerY;
    private int xOffset;
    private int yOffset;
    public static final WidgetSprites BACK_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"je", (String)"timeworn_journal/timeworn_journal_back_button"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"timeworn_journal/timeworn_journal_back_button_highlighted"));

    public BaseTimewornJournalScreen() {
        super((Component)Component.translatable((String)"screen.je.timeworn_journal_title"));
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        super.init();
        this.bookWidth = 400;
        this.bookHeight = 216;
        this.centerX = this.width / 2;
        this.centerY = this.height / 2;
        this.xOffset = Math.round(this.bookWidth / 11);
        this.yOffset = 10;
        this.bgStartX = this.centerX - (this.bookWidth - this.xOffset) / 2;
        this.bgStartY = this.centerY - this.bookHeight / 2 - this.yOffset;
    }

    public void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderTransparentBackground(pGuiGraphics);
        pGuiGraphics.blit(BG_LOCATION, this.bgStartX, this.bgStartY, 0, 0.0f, 0.0f, this.bookWidth, this.bookHeight, this.bookWidth, this.bookHeight);
    }

    protected void renderBackButton(@Nullable Screen backScreen) {
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.bgStartX + 18, this.bgStartY + this.bookHeight - 36, 20, 20, BACK_BUTTON_SPRITES, p_308203_ -> this.minecraft.setScreen(backScreen)));
    }

    protected int getBgStartX() {
        return this.bgStartX;
    }

    protected int getBgStartY() {
        return this.bgStartY;
    }

    protected int getBgEndX() {
        return this.bgStartX + this.bookWidth;
    }

    protected int getBgEndY() {
        return this.bgStartY + this.bookHeight;
    }

    protected int getBgWidth() {
        return this.bookWidth;
    }

    protected int getBgHeight() {
        return this.bookHeight;
    }

    protected void writeText(GuiGraphics pGuiGraphics, Component pText, int pX, int pY) {
        FormattedCharSequence formattedcharsequence = pText.getVisualOrderText();
        pGuiGraphics.drawString(this.font, formattedcharsequence, pX - this.font.width(formattedcharsequence) / 2, pY, 12559971, false);
    }
}

