/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.screen.timeworn_journal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.je.common.screen.timeworn_journal.BaseTimewornJournalScreen;
import net.je.common.screen.timeworn_journal.TimewornJournalButton;
import net.je.common.screen.timeworn_journal.TimewornJournalEditBox;
import net.je.common.screen.timeworn_journal.entry.BaseTimewornJournalEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class TimewornJournalScrollableScreen
extends BaseTimewornJournalScreen {
    private final List<Button> allButtons = new ArrayList<Button>();
    private final List<Button> filteredButtons = new ArrayList<Button>();
    private final List<BaseTimewornJournalEntry> allEntries;
    private final Map<Button, BaseTimewornJournalEntry> buttonEntryMap = new HashMap<Button, BaseTimewornJournalEntry>();
    private final Map<Button, String> trimmedButtonTooltips = new HashMap<Button, String>();
    private EditBox searchField;
    protected int scrollOffset = 0;
    private boolean draggingScrollbar = false;
    private int listTop;
    private int listHeight;
    private int listLeft;
    private int listRight;
    private int listWidth;
    private final int buttonHeight = 18;
    private final int maxVisibleButtons = 8;
    private int dragStartY = 0;
    private float initialThumbProgress = 0.0f;
    private int searchBoxY;
    private int searchWidth;
    private final int searchHeight = 16;
    private String oldSearchValue = "";

    public TimewornJournalScrollableScreen(List<BaseTimewornJournalEntry> pList) {
        this.allEntries = new ArrayList<BaseTimewornJournalEntry>(pList);
        this.allEntries.sort((a, b) -> a.getName().getString().compareToIgnoreCase(b.getName().getString()));
    }

    @Override
    protected void init() {
        super.init();
        this.listTop = super.getBgStartY() + 40;
        this.listLeft = super.getBgStartX() + 40;
        this.searchBoxY = this.listTop - 20;
        this.listWidth = (int)((double)Math.round(super.getBgWidth() - 50) * 0.3);
        this.searchWidth = this.listWidth + 10;
        this.listRight = this.listLeft + this.listWidth;
        this.listHeight = 144;
        this.searchField = new TimewornJournalEditBox(this.font, this.listLeft - 5, this.searchBoxY, this.searchWidth, 16, (Component)Component.translatable((String)"screen.je.search"));
        this.searchField.setResponder(s -> this.updateFilteredButtons());
        this.searchField.setHint((Component)Component.translatable((String)"screen.je.search").withStyle(ChatFormatting.ITALIC));
        this.addRenderableWidget((GuiEventListener)this.searchField);
        for (BaseTimewornJournalEntry entry : this.allEntries) {
            int maxTextWidth;
            String fullText = entry.getName().getString();
            Object trimmedText = this.font.plainSubstrByWidth(fullText, maxTextWidth = this.listWidth - 10);
            if (!((String)trimmedText).equals(fullText)) {
                trimmedText = this.font.plainSubstrByWidth(fullText, maxTextWidth - this.font.width("...")) + "...";
            }
            TimewornJournalButton button = new TimewornJournalButton(this.listLeft, 0, this.listWidth, 18, (Component)Component.literal((String)trimmedText), b -> this.onButtonClicked(entry));
            this.allButtons.add(button);
            this.buttonEntryMap.put(button, entry);
            if (((String)trimmedText).equals(fullText)) continue;
            this.trimmedButtonTooltips.put(button, fullText);
        }
        this.updateFilteredButtons();
    }

    protected void onButtonClicked(BaseTimewornJournalEntry pEntry) {
    }

    public void setScrollOffset(int pScrollOffset) {
        this.scrollOffset = pScrollOffset;
    }

    private void updateFilteredButtons() {
        this.allEntries.sort((a, b) -> a.getName().getString().compareToIgnoreCase(b.getName().getString()));
        String search = this.searchField.getValue().toLowerCase();
        this.filteredButtons.clear();
        this.trimmedButtonTooltips.clear();
        for (BaseTimewornJournalEntry entry : this.allEntries) {
            String fullName = entry.getName().getString();
            if (!fullName.toLowerCase().contains(search)) continue;
            int maxTextWidth = this.listWidth - 10;
            Object trimmedText = this.font.plainSubstrByWidth(fullName, maxTextWidth);
            if (!((String)trimmedText).equals(fullName)) {
                trimmedText = this.font.plainSubstrByWidth(fullName, maxTextWidth - this.font.width("...")) + "...";
            }
            TimewornJournalButton button = new TimewornJournalButton(this.listLeft, 0, this.listWidth, 18, (Component)Component.literal((String)trimmedText), b -> this.onButtonClicked(entry));
            this.filteredButtons.add(button);
            this.buttonEntryMap.put(button, entry);
            if (((String)trimmedText).equals(fullName)) continue;
            this.trimmedButtonTooltips.put(button, fullName);
        }
        if (!search.equals(this.oldSearchValue)) {
            this.scrollOffset = 0;
            this.oldSearchValue = search;
        }
        this.draggingScrollbar = false;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        int maxScroll = Math.max(0, this.filteredButtons.size() - 8);
        this.scrollOffset -= (int)pScrollY;
        this.scrollOffset = Mth.clamp((int)this.scrollOffset, (int)0, (int)maxScroll);
        return true;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 265 || pKeyCode == 264) {
            this.scrollOffset = Mth.clamp((int)(this.scrollOffset + (pKeyCode == 265 ? -1 : 1)), (int)0, (int)Math.max(0, this.filteredButtons.size() - 8));
            return true;
        }
        if (pKeyCode == 266 || pKeyCode == 267) {
            this.scrollOffset = Mth.clamp((int)(this.scrollOffset + (pKeyCode == 266 ? -1 : 1) * 8), (int)0, (int)Math.max(0, this.filteredButtons.size() - 8));
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void render(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(pGuiGraphics, mouseX, mouseY, partialTick);
        this.searchField.render(pGuiGraphics, mouseX, mouseY, partialTick);
        int visibleStart = this.scrollOffset;
        int visibleEnd = Math.min(this.scrollOffset + 8, this.filteredButtons.size());
        for (int i = visibleStart; i < visibleEnd; ++i) {
            Button btn = this.filteredButtons.get(i);
            btn.setX(this.listLeft);
            btn.setY(this.listTop + (i - visibleStart) * 19);
            btn.render(pGuiGraphics, mouseX, mouseY, partialTick);
            if (!btn.isMouseOver((double)mouseX, (double)mouseY) || !this.trimmedButtonTooltips.containsKey(btn)) continue;
            pGuiGraphics.renderTooltip(this.font, (Component)Component.literal((String)this.trimmedButtonTooltips.get(btn)), mouseX, mouseY);
        }
        int scrollbarX = this.listRight + 4;
        int scrollbarY = this.listTop;
        int scrollbarHeight = this.listHeight;
        int totalButtons = this.filteredButtons.size();
        if (totalButtons > 8) {
            float ratio = 8.0f / (float)totalButtons;
            int thumbHeight = Math.max(10, (int)(ratio * (float)scrollbarHeight));
            float thumbProgress = (float)this.scrollOffset / (float)(totalButtons - 8);
            int thumbY = scrollbarY + (int)(thumbProgress * (float)(scrollbarHeight - thumbHeight));
            boolean mouseOverThumb = mouseX >= scrollbarX && mouseX < scrollbarX + 6 && mouseY >= thumbY && mouseY < thumbY + thumbHeight;
            int thumbColor = this.draggingScrollbar || mouseOverThumb ? -6059192 : -4874128;
            pGuiGraphics.fill(scrollbarX, scrollbarY, scrollbarX + 6, scrollbarY + scrollbarHeight, -3030634);
            pGuiGraphics.fill(scrollbarX, thumbY, scrollbarX + 6, thumbY + thumbHeight, thumbColor);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (!(mouseX >= (double)this.listLeft && mouseX < (double)(this.listLeft + this.searchWidth) && mouseY >= (double)this.searchBoxY && mouseY < (double)(this.searchBoxY + 16))) {
                this.searchField.setFocused(false);
            }
            int scrollbarX = this.listRight + 4;
            int scrollbarY = this.listTop;
            int scrollbarHeight = this.listHeight;
            int totalButtons = this.filteredButtons.size();
            if (totalButtons > 8) {
                int thumbHeight = Math.max(10, (int)(8.0f / (float)totalButtons * (float)scrollbarHeight));
                float thumbProgress = (float)this.scrollOffset / (float)(totalButtons - 8);
                int thumbY = scrollbarY + (int)(thumbProgress * (float)(scrollbarHeight - thumbHeight));
                if (mouseX >= (double)scrollbarX && mouseX < (double)(scrollbarX + 6) && mouseY >= (double)thumbY && mouseY < (double)(thumbY + thumbHeight)) {
                    this.draggingScrollbar = true;
                    this.dragStartY = (int)mouseY;
                    this.initialThumbProgress = thumbProgress;
                    return true;
                }
            }
            int visibleStart = this.scrollOffset;
            int visibleEnd = Math.min(this.scrollOffset + 8, this.filteredButtons.size());
            for (int i = visibleStart; i < visibleEnd; ++i) {
                Button btn = this.filteredButtons.get(i);
                if (!btn.mouseClicked(mouseX, mouseY, button)) continue;
                BaseTimewornJournalEntry entry = this.buttonEntryMap.get(btn);
                this.onButtonClicked(entry);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.draggingScrollbar) {
            int totalButtons = this.filteredButtons.size();
            if (totalButtons <= 8) {
                return true;
            }
            int scrollbarHeight = this.listHeight;
            int thumbHeight = Math.max(10, (int)(8.0f / (float)totalButtons * (float)scrollbarHeight));
            float deltaY = (int)mouseY - this.dragStartY;
            float progressDelta = deltaY / (float)(scrollbarHeight - thumbHeight);
            float newThumbProgress = this.initialThumbProgress + progressDelta;
            newThumbProgress = Mth.clamp((float)newThumbProgress, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)(newThumbProgress * (float)(totalButtons - 8));
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dx, dy);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggingScrollbar = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }
}

