/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.screen.timeworn_journal.entry;

import java.util.ArrayList;
import java.util.List;
import net.je.common.block.ModBlocks;
import net.je.common.entity.ModEntities;
import net.je.common.entity.custom.EndersentWithEye;
import net.je.common.screen.timeworn_journal.entry.BaseTimewornJournalEntry;
import net.je.common.screen.timeworn_journal.entry.EntityEntry;
import net.je.common.screen.timeworn_journal.entry.ImageEntry;
import net.je.common.screen.timeworn_journal.entry.ItemEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class TimewornJournalEntries {
    private static final int maxTier = 2;
    public static final List<BaseTimewornJournalEntry> CHAPTER_ENTRIES_T0 = List.of(new BaseTimewornJournalEntry(TimewornJournalEntries.name("about_book"), TimewornJournalEntries.lore("about_book")), new BaseTimewornJournalEntry(TimewornJournalEntries.name("chapter_1"), TimewornJournalEntries.lore("chapter_1")), new BaseTimewornJournalEntry(TimewornJournalEntries.name("about_mod"), TimewornJournalEntries.lore("about_mod")));
    public static final List<BaseTimewornJournalEntry> CHAPTER_ENTRIES_T1 = List.of(new BaseTimewornJournalEntry(TimewornJournalEntries.name("chapter_2"), TimewornJournalEntries.lore("chapter_2")));
    public static final List<BaseTimewornJournalEntry> CHAPTER_ENTRIES_T2 = List.of(new BaseTimewornJournalEntry(TimewornJournalEntries.name("placeholder_entry"), TimewornJournalEntries.lore("placeholder_entry")));
    public static final List<BaseTimewornJournalEntry> PROGRESSION_ENTRIES_T0 = List.of(new ImageEntry(TimewornJournalEntries.name("progression_1"), TimewornJournalEntries.lore("progression_1"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/item/eye_fragment.png")));
    public static final List<BaseTimewornJournalEntry> PROGRESSION_ENTRIES_T1 = List.of(new ImageEntry(TimewornJournalEntries.name("progression_2"), TimewornJournalEntries.lore("progression_2"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/item/voidmetal_ingot.png")));
    public static final List<BaseTimewornJournalEntry> BLOCK_ENTRIES_T0 = List.of(new ItemEntry(TimewornJournalEntries.name("corrupted_dirt"), TimewornJournalEntries.lore("corrupted_dirt"), TimewornJournalEntries.stack((Block)ModBlocks.CORRUPTED_DIRT.get())), new ItemEntry(TimewornJournalEntries.name("void_stone"), TimewornJournalEntries.lore("void_stone"), TimewornJournalEntries.stack((Block)ModBlocks.VOID_STONE.get())), new ItemEntry(TimewornJournalEntries.name("voidmass"), TimewornJournalEntries.lore("voidmass"), TimewornJournalEntries.stack((Block)ModBlocks.VOIDMASS.get())), new ImageEntry(TimewornJournalEntries.name("voidbloom"), TimewornJournalEntries.lore("voidbloom"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/item/voidbloom_item.png")), new ImageEntry(TimewornJournalEntries.name("voidblight"), TimewornJournalEntries.lore("voidblight"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/block/voidblight_icon.png")), new ItemEntry(TimewornJournalEntries.name("bejeweled_pedestal"), TimewornJournalEntries.lore("bejeweled_pedestal"), TimewornJournalEntries.stack((Block)ModBlocks.BEJEWELED_PEDESTAL.get())));
    public static final List<BaseTimewornJournalEntry> BLOCK_ENTRIES_T1 = List.of(new ItemEntry(TimewornJournalEntries.name("end_stone"), TimewornJournalEntries.lore("end_stone"), TimewornJournalEntries.stack(Blocks.END_STONE)), new ItemEntry(TimewornJournalEntries.name("faded_end_stone"), TimewornJournalEntries.lore("faded_end_stone"), TimewornJournalEntries.stack((Block)ModBlocks.FADED_END_STONE.get())), new ItemEntry(TimewornJournalEntries.name("lush_end_stone"), TimewornJournalEntries.lore("lush_end_stone"), TimewornJournalEntries.stack((Block)ModBlocks.LUSH_END_STONE.get())), new ItemEntry(TimewornJournalEntries.name("compressed_end_stone"), TimewornJournalEntries.lore("compressed_end_stone"), TimewornJournalEntries.stack((Block)ModBlocks.COMPRESSED_END_STONE.get())), new ItemEntry(TimewornJournalEntries.name("end_stone_furnace"), TimewornJournalEntries.lore("end_stone_furnace"), TimewornJournalEntries.stack((Block)ModBlocks.END_STONE_FURNACE.get())), new ItemEntry(TimewornJournalEntries.name("interdimensional_anchor"), TimewornJournalEntries.lore("interdimensional_anchor"), TimewornJournalEntries.stack((Block)ModBlocks.INTERDIMENSIONAL_ANCHOR.get())), new ItemEntry(TimewornJournalEntries.name("lantern_of_warding"), TimewornJournalEntries.lore("lantern_of_warding"), TimewornJournalEntries.stack((Block)ModBlocks.LANTERN_OF_WARDING.get())), new ItemEntry(TimewornJournalEntries.name("ender_vault"), TimewornJournalEntries.lore("ender_vault"), TimewornJournalEntries.stack((Block)ModBlocks.ENDER_VAULT.get())), new ItemEntry(TimewornJournalEntries.name("voidmetal_block"), TimewornJournalEntries.lore("voidmetal_block"), TimewornJournalEntries.stack((Block)ModBlocks.VOIDMETAL_BLOCK.get())));
    public static final List<BaseTimewornJournalEntry> ITEM_ENTRIES_T0 = List.of(new ImageEntry(TimewornJournalEntries.name("voidblight_bucket"), TimewornJournalEntries.lore("voidblight_bucket"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/item/voidblight_bucket.png")), new ImageEntry(TimewornJournalEntries.name("ender_pearl"), TimewornJournalEntries.lore("ender_pearl"), ResourceLocation.withDefaultNamespace((String)"textures/item/ender_pearl.png")), new ImageEntry(TimewornJournalEntries.name("ender_eye"), TimewornJournalEntries.lore("ender_eye"), ResourceLocation.withDefaultNamespace((String)"textures/item/ender_eye.png")), new ImageEntry(TimewornJournalEntries.name("eye_fragment"), TimewornJournalEntries.lore("eye_fragment"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/item/eye_fragment.png")));
    public static final List<BaseTimewornJournalEntry> ITEM_ENTRIES_T1 = List.of(new ImageEntry(TimewornJournalEntries.name("small_void_dust"), TimewornJournalEntries.lore("small_void_dust"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/item/small_void_dust.png")), new ImageEntry(TimewornJournalEntries.name("void_dust"), TimewornJournalEntries.lore("void_dust"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/item/void_dust.png")), new ImageEntry(TimewornJournalEntries.name("raw_voidmetal"), TimewornJournalEntries.lore("raw_voidmetal"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/item/raw_voidmetal.png")), new ImageEntry(TimewornJournalEntries.name("voidmetal_ingot"), TimewornJournalEntries.lore("voidmetal_ingot"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/item/voidmetal_ingot.png")), new ImageEntry(TimewornJournalEntries.name("voidmetal_nugget"), TimewornJournalEntries.lore("voidmetal_nugget"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/item/voidmetal_nugget.png")), new ImageEntry(TimewornJournalEntries.name("voidmetal_upgrade_smithing_template"), TimewornJournalEntries.lore("voidmetal_upgrade_smithing_template"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/item/voidmetal_upgrade_smithing_template.png")));
    public static final List<BaseTimewornJournalEntry> STRUCTURE_ENTRIES_T0 = List.of(new ImageEntry(TimewornJournalEntries.name("endersent_well"), TimewornJournalEntries.lore("endersent_well"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/gui/journal_icons/endersent_well.png")), new ImageEntry(TimewornJournalEntries.name("stronghold"), TimewornJournalEntries.lore("stronghold"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/gui/journal_icons/stronghold.png")));
    public static final List<BaseTimewornJournalEntry> STRUCTURE_ENTRIES_T1 = List.of(new ImageEntry(TimewornJournalEntries.name("end_city"), TimewornJournalEntries.lore("end_city"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/gui/journal_icons/end_city.png")));
    public static final List<BaseTimewornJournalEntry> BIOME_ENTRIES_T0 = List.of(new ImageEntry(TimewornJournalEntries.name("main_island"), TimewornJournalEntries.lore("main_island"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/gui/journal_icons/main_island.png")));
    public static final List<BaseTimewornJournalEntry> BIOME_ENTRIES_T1 = List.of(new ImageEntry(TimewornJournalEntries.name("outer_islands"), TimewornJournalEntries.lore("outer_islands"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/gui/journal_icons/outer_islands.png")));
    public static final List<BaseTimewornJournalEntry> ENTITY_ENTRIES = List.of(new EntityEntry(TimewornJournalEntries.name("endersent"), TimewornJournalEntries.lore("endersent"), (LivingEntity)new EndersentWithEye((EntityType<? extends Monster>)((EntityType)ModEntities.ENDERSENT_WITH_EYE.get()), (Level)Minecraft.getInstance().level), 25.0f, 0.3f), new EntityEntry(TimewornJournalEntries.name("enderman"), TimewornJournalEntries.lore("enderman"), (LivingEntity)new EnderMan(EntityType.ENDERMAN, (Level)Minecraft.getInstance().level), 50.0f, 0.3f), new EntityEntry(TimewornJournalEntries.name("endermite"), TimewornJournalEntries.lore("endermite"), (LivingEntity)new Endermite(EntityType.ENDERMITE, (Level)Minecraft.getInstance().level), 120.0f, 0.1f), new ImageEntry(TimewornJournalEntries.name("ender_dragon"), TimewornJournalEntries.lore("ender_dragon"), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/gui/journal_icons/ender_dragon.png")));

    private static ItemStack stack(Item pItem) {
        return new ItemStack((ItemLike)pItem);
    }

    private static ItemStack stack(Block pBlock) {
        return new ItemStack((ItemLike)pBlock);
    }

    private static Component name(String path) {
        String start = "screen.je.title.";
        return Component.translatable((String)(start + path));
    }

    private static Component lore(String path) {
        String start = "screen.je.lore.";
        return Component.translatable((String)(start + path));
    }

    public static List<BaseTimewornJournalEntry> getChapterList(int pTier) {
        int i;
        int tier = Math.clamp((long)pTier, 0, 2);
        ArrayList<BaseTimewornJournalEntry> finalList = new ArrayList<BaseTimewornJournalEntry>();
        for (i = 0; i < CHAPTER_ENTRIES_T0.size(); ++i) {
            finalList.add(CHAPTER_ENTRIES_T0.get(i));
        }
        if (tier >= 1) {
            for (i = 0; i < CHAPTER_ENTRIES_T1.size(); ++i) {
                finalList.add(CHAPTER_ENTRIES_T1.get(i));
            }
        }
        if (tier >= 2) {
            System.out.println("adding tier 2 entries");
            finalList.add(CHAPTER_ENTRIES_T2.getFirst());
        }
        System.out.println(tier);
        return finalList;
    }

    public static List<BaseTimewornJournalEntry> getProgressionList(int pTier) {
        int i;
        int tier = Math.clamp((long)pTier, 0, 2);
        ArrayList<BaseTimewornJournalEntry> finalList = new ArrayList<BaseTimewornJournalEntry>();
        for (i = 0; i < PROGRESSION_ENTRIES_T0.size(); ++i) {
            finalList.add(PROGRESSION_ENTRIES_T0.get(i));
        }
        if (tier >= 1) {
            for (i = 0; i < PROGRESSION_ENTRIES_T1.size(); ++i) {
                finalList.add(PROGRESSION_ENTRIES_T1.get(i));
            }
        }
        return finalList;
    }

    public static List<BaseTimewornJournalEntry> getBlockList(int pTier) {
        int i;
        int tier = Math.clamp((long)pTier, 0, 2);
        ArrayList<BaseTimewornJournalEntry> finalList = new ArrayList<BaseTimewornJournalEntry>();
        for (i = 0; i < BLOCK_ENTRIES_T0.size(); ++i) {
            finalList.add(BLOCK_ENTRIES_T0.get(i));
        }
        if (tier >= 1) {
            for (i = 0; i < BLOCK_ENTRIES_T1.size(); ++i) {
                finalList.add(BLOCK_ENTRIES_T1.get(i));
            }
        }
        return finalList;
    }

    public static List<BaseTimewornJournalEntry> getItemList(int pTier) {
        int i;
        int tier = Math.clamp((long)pTier, 0, 2);
        ArrayList<BaseTimewornJournalEntry> finalList = new ArrayList<BaseTimewornJournalEntry>();
        for (i = 0; i < ITEM_ENTRIES_T0.size(); ++i) {
            finalList.add(ITEM_ENTRIES_T0.get(i));
        }
        if (tier >= 1) {
            for (i = 0; i < ITEM_ENTRIES_T1.size(); ++i) {
                finalList.add(ITEM_ENTRIES_T1.get(i));
            }
        }
        String journalTier = "timeworn_journal_t" + pTier;
        finalList.add(new ImageEntry(TimewornJournalEntries.name(journalTier), TimewornJournalEntries.lore(journalTier), ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/item/timeworn_journal.png")));
        return finalList;
    }

    public static List<BaseTimewornJournalEntry> getStructureList(int pTier) {
        int i;
        int tier = Math.clamp((long)pTier, 0, 2);
        ArrayList<BaseTimewornJournalEntry> finalList = new ArrayList<BaseTimewornJournalEntry>();
        for (i = 0; i < STRUCTURE_ENTRIES_T0.size(); ++i) {
            finalList.add(STRUCTURE_ENTRIES_T0.get(i));
        }
        if (tier >= 1) {
            for (i = 0; i < STRUCTURE_ENTRIES_T1.size(); ++i) {
                finalList.add(STRUCTURE_ENTRIES_T1.get(i));
            }
        }
        return finalList;
    }

    public static List<BaseTimewornJournalEntry> getBiomeList(int pTier) {
        int i;
        int tier = Math.clamp((long)pTier, 0, 2);
        ArrayList<BaseTimewornJournalEntry> finalList = new ArrayList<BaseTimewornJournalEntry>();
        for (i = 0; i < BIOME_ENTRIES_T0.size(); ++i) {
            finalList.add(BIOME_ENTRIES_T0.get(i));
        }
        if (tier >= 1) {
            for (i = 0; i < BIOME_ENTRIES_T1.size(); ++i) {
                finalList.add(BIOME_ENTRIES_T1.get(i));
            }
        }
        return finalList;
    }

    public static List<BaseTimewornJournalEntry> getEntityList(int pTier) {
        int tier = Math.clamp((long)pTier, 0, 2);
        ArrayList<BaseTimewornJournalEntry> finalList = new ArrayList<BaseTimewornJournalEntry>();
        for (int i = 0; i < ENTITY_ENTRIES.size(); ++i) {
            finalList.add(ENTITY_ENTRIES.get(i));
        }
        return finalList;
    }
}

