/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.screen.timeworn_journal.entry.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.je.common.screen.timeworn_journal.BaseTimewornJournalScreen;
import net.je.common.screen.timeworn_journal.entry.BaseTimewornJournalEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BaseTimewornJournalEntryScreen
extends BaseTimewornJournalScreen {
    private int loreX;
    private int loreY;
    private int loreScrollOffset = 0;
    private final int loreLineHeight = 10;
    private final int maxVisibleLoreLines = 14;
    private boolean draggingLoreScrollbar = false;
    private int loreDragStartY = 0;
    private float initialLoreThumbProgress = 0.0f;
    private int loreScrollbarX;
    protected BaseTimewornJournalEntry entry;
    private final int scrollOffset;
    private Screen backScreen;

    public BaseTimewornJournalEntryScreen(BaseTimewornJournalEntry pEntry) {
        this.scrollOffset = 0;
        this.entry = pEntry;
    }

    public BaseTimewornJournalEntryScreen(BaseTimewornJournalEntry pEntry, int pScrollOffset, @Nullable Screen pBackScreen) {
        this.scrollOffset = pScrollOffset;
        this.entry = pEntry;
    }

    @Override
    public void init() {
        super.init();
        this.loreX = super.getBgStartX() + (int)((double)Math.round(super.getBgWidth() - 50) * 0.3) + 90;
        this.loreY = super.getBgStartY() + 45;
        this.loreScrollbarX = this.loreX + 130;
        this.renderBackButton(this.backScreen);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 265 || pKeyCode == 264) {
            List<String> loreLines = BaseTimewornJournalEntryScreen.wrapText(this.font, this.entry.getLore().getString(), 125);
            this.loreScrollOffset = Mth.clamp((int)(this.loreScrollOffset + (pKeyCode == 265 ? -1 : 1)), (int)0, (int)Math.max(0, loreLines.size() - 14));
            return true;
        }
        if (pKeyCode == 266 || pKeyCode == 267) {
            List<String> loreLines = BaseTimewornJournalEntryScreen.wrapText(this.font, this.entry.getLore().getString(), 125);
            this.loreScrollOffset = Mth.clamp((int)(this.loreScrollOffset + (pKeyCode == 266 ? -1 : 1) * 14), (int)0, (int)Math.max(0, loreLines.size() - 14));
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void render(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(pGuiGraphics, mouseX, mouseY, partialTick);
        List<String> loreLines = BaseTimewornJournalEntryScreen.wrapText(this.font, this.entry.getLore().getString(), 125);
        int loreHeight = 120;
        int visibleStartLore = this.loreScrollOffset;
        int visibleEndLore = Math.min(loreLines.size(), this.loreScrollOffset + 14);
        pGuiGraphics.drawString(this.font, this.entry.getName(), this.loreX, this.loreY - 20, 0, false);
        for (int i = visibleStartLore; i < visibleEndLore; ++i) {
            pGuiGraphics.drawString(this.font, loreLines.get(i), this.loreX, this.loreY + (i - visibleStartLore) * 10, 0, false);
        }
        if (loreLines.size() > 14) {
            float ratio = 14.0f / (float)loreLines.size();
            int thumbHeight = Math.max(10, (int)(ratio * (float)loreHeight));
            float thumbProgress = (float)this.loreScrollOffset / (float)(loreLines.size() - 14);
            int thumbY = this.loreY + (int)(thumbProgress * (float)(loreHeight - thumbHeight));
            boolean mouseOverThumb = mouseX >= this.loreScrollbarX && mouseX < this.loreScrollbarX + 6 && mouseY >= thumbY && mouseY < thumbY + thumbHeight;
            int scrollbarColor = this.draggingLoreScrollbar || mouseOverThumb ? -6059192 : -4874128;
            pGuiGraphics.fill(this.loreScrollbarX, this.loreY, this.loreScrollbarX + 6, this.loreY + loreHeight, -3030634);
            pGuiGraphics.fill(this.loreScrollbarX, thumbY, this.loreScrollbarX + 6, thumbY + thumbHeight, scrollbarColor);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        List<String> loreLines = BaseTimewornJournalEntryScreen.wrapText(this.font, this.entry.getLore().getString(), 125);
        int loreHeight = 120;
        int thumbHeight = Math.max(10, (int)(14.0f / (float)loreLines.size() * (float)loreHeight));
        float thumbProgress = (float)this.loreScrollOffset / (float)(loreLines.size() - 14);
        int thumbY = this.loreY + (int)(thumbProgress * (float)(loreHeight - thumbHeight));
        if (mouseX >= (double)this.loreScrollbarX && mouseX < (double)(this.loreScrollbarX + 6) && mouseY >= (double)thumbY && mouseY < (double)(thumbY + thumbHeight)) {
            this.draggingLoreScrollbar = true;
            this.loreDragStartY = (int)mouseY;
            this.initialLoreThumbProgress = thumbProgress;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.draggingLoreScrollbar) {
            List<String> loreLines = BaseTimewornJournalEntryScreen.wrapText(this.font, this.entry.getLore().getString(), 125);
            int loreHeight = 120;
            int thumbHeight = Math.max(10, (int)(14.0f / (float)loreLines.size() * (float)loreHeight));
            float deltaY = (int)mouseY - this.loreDragStartY;
            float progressDelta = deltaY / (float)(loreHeight - thumbHeight);
            float newThumbProgress = this.initialLoreThumbProgress + progressDelta;
            newThumbProgress = Mth.clamp((float)newThumbProgress, (float)0.0f, (float)1.0f);
            this.loreScrollOffset = (int)(newThumbProgress * (float)(loreLines.size() - 14));
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dx, dy);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggingLoreScrollbar = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        List<String> loreLines = BaseTimewornJournalEntryScreen.wrapText(this.font, this.entry.getLore().getString(), 125);
        int maxScroll = Math.max(0, loreLines.size() - 14);
        this.loreScrollOffset -= (int)pScrollY;
        this.loreScrollOffset = Mth.clamp((int)this.loreScrollOffset, (int)0, (int)maxScroll);
        return true;
    }

    public static List<String> wrapText(Font font, String text, int maxWidth) {
        ArrayList<String> wrappedLines = new ArrayList<String>();
        if (text == null || text.isEmpty()) {
            return wrappedLines;
        }
        String[] words = text.split("\\s+");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.isEmpty() ? word : String.valueOf(currentLine) + " " + word;
            if (font.width(testLine) > maxWidth) {
                wrappedLines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            currentLine = new StringBuilder(testLine);
        }
        if (!currentLine.isEmpty()) {
            wrappedLines.add(currentLine.toString());
        }
        return wrappedLines;
    }

    public void renderBlock(GuiGraphics guiGraphics, ItemStack stack) {
        float scale = 120.0f;
        int x = (int)((double)(this.width / 2) - (double)super.getBgWidth() * 0.21);
        int y = (int)((double)(this.height / 2) - (double)super.getBgHeight() * 0.05);
        guiGraphics.flush();
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 200.0f);
        poseStack.scale(scale, -scale, scale);
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GUI, 0xF000F0, OverlayTexture.NO_OVERLAY, poseStack, (MultiBufferSource)guiGraphics.bufferSource(), null, 0);
        guiGraphics.flush();
        poseStack.popPose();
    }

    public void renderItem(GuiGraphics guiGraphics, ResourceLocation pTexture) {
        float scale = 7.0f;
        int x = (int)((double)(this.width / 2) - (double)super.getBgWidth() * 0.21 - (double)((int)scale * 8));
        int y = (int)((double)(this.height / 2) - (double)super.getBgHeight() * 0.05 - (double)((int)scale * 8));
        guiGraphics.blit(pTexture, x, y, 0, 0.0f, 0.0f, (int)scale * 16, (int)scale * 16, (int)scale * 16, (int)scale * 16);
    }

    public void renderImageFrame(GuiGraphics guiGraphics) {
        float scale = 9.0f;
        int x = (int)((double)(this.width / 2) - (double)super.getBgWidth() * 0.21 - (double)((int)scale * 8));
        int y = (int)((double)(this.height / 2) - (double)super.getBgHeight() * 0.05 - (double)((int)scale * 8));
        guiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/gui/timeworn_journal_button_frame.png"), x, y, 0, 0.0f, 0.0f, (int)scale * 16, (int)scale * 16, (int)scale * 16, (int)scale * 16);
    }
}

