/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.screen.timeworn_journal.entry.renderer;

import net.je.common.screen.timeworn_journal.TimewornJournalScrollableScreen;
import net.je.common.screen.timeworn_journal.entry.BaseTimewornJournalEntry;
import net.je.common.screen.timeworn_journal.entry.EntityEntry;
import net.je.common.screen.timeworn_journal.entry.ImageEntry;
import net.je.common.screen.timeworn_journal.entry.ItemEntry;
import net.je.common.screen.timeworn_journal.entry.renderer.BaseTimewornJournalEntryScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class TimewornJournalEntryScreens {

    public static class TimewornJournalBlockEntryScreen
    extends BaseTimewornJournalEntryScreen {
        private final int scrollOffset;
        private ItemEntry entry;
        private ImageEntry imageEntry;
        private final TimewornJournalScrollableScreen backScreen;

        public TimewornJournalBlockEntryScreen(ItemEntry pEntry, TimewornJournalScrollableScreen listScreen) {
            super(pEntry);
            this.scrollOffset = 0;
            this.entry = pEntry;
            this.backScreen = listScreen;
            this.backScreen.setScrollOffset(this.scrollOffset);
        }

        public TimewornJournalBlockEntryScreen(ItemEntry pEntry, int pScrollOffset, TimewornJournalScrollableScreen listScreen) {
            super(pEntry, pScrollOffset, listScreen);
            this.scrollOffset = pScrollOffset;
            this.entry = pEntry;
            this.backScreen = listScreen;
            this.backScreen.setScrollOffset(this.scrollOffset);
        }

        public TimewornJournalBlockEntryScreen(ImageEntry pEntry, TimewornJournalScrollableScreen listScreen) {
            super(pEntry);
            this.scrollOffset = 0;
            this.imageEntry = pEntry;
            this.backScreen = listScreen;
            this.backScreen.setScrollOffset(this.scrollOffset);
        }

        public TimewornJournalBlockEntryScreen(ImageEntry pEntry, int pScrollOffset, TimewornJournalScrollableScreen listScreen) {
            super(pEntry, pScrollOffset, listScreen);
            this.scrollOffset = pScrollOffset;
            this.imageEntry = pEntry;
            this.backScreen = listScreen;
            this.backScreen.setScrollOffset(this.scrollOffset);
        }

        @Override
        protected void renderBackButton(@Nullable Screen pBackScreen) {
            this.addRenderableWidget((GuiEventListener)new ImageButton(super.getBgStartX() + 18, super.getBgStartY() + super.getBgHeight() - 36, 20, 20, BACK_BUTTON_SPRITES, p_308203_ -> this.minecraft.setScreen((Screen)this.backScreen)));
        }

        @Override
        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.render(guiGraphics, mouseX, mouseY, partialTick);
            if (this.entry != null) {
                ItemStack stack = this.entry.getItem();
                super.renderBlock(guiGraphics, stack);
            } else if (this.imageEntry != null) {
                ResourceLocation sprite = this.imageEntry.getImage();
                super.renderItem(guiGraphics, sprite);
            }
        }
    }

    public static class TimewornJournalEntityEntryScreen
    extends BaseTimewornJournalEntryScreen {
        private final int scrollOffset;
        private final LivingEntity entity;
        private final EntityEntry entry;
        private final TimewornJournalScrollableScreen backScreen;
        private final float scale;

        public TimewornJournalEntityEntryScreen(EntityEntry pEntry, TimewornJournalScrollableScreen listScreen) {
            super(pEntry);
            this.scrollOffset = 0;
            this.entry = pEntry;
            this.backScreen = listScreen;
            this.backScreen.setScrollOffset(this.scrollOffset);
            this.entity = (LivingEntity)this.entry.getEntity();
            this.scale = this.entry.getScale().floatValue();
        }

        public TimewornJournalEntityEntryScreen(EntityEntry pEntry, int pScrollOffset, TimewornJournalScrollableScreen listScreen) {
            super(pEntry, pScrollOffset, listScreen);
            this.scrollOffset = pScrollOffset;
            this.entry = pEntry;
            this.backScreen = listScreen;
            this.backScreen.setScrollOffset(this.scrollOffset);
            this.entity = (LivingEntity)this.entry.getEntity();
            this.scale = this.entry.getScale().floatValue();
        }

        @Override
        protected void renderBackButton(@Nullable Screen pBackScreen) {
            this.addRenderableWidget((GuiEventListener)new ImageButton(super.getBgStartX() + 18, super.getBgStartY() + super.getBgHeight() - 36, 20, 20, BACK_BUTTON_SPRITES, p_308203_ -> this.minecraft.setScreen((Screen)this.backScreen)));
        }

        @Override
        public void init() {
            float bodyYaw;
            super.init();
            this.entity.yBodyRot = bodyYaw = 210.0f;
            this.entity.setYRot(bodyYaw);
            this.entity.setYHeadRot(bodyYaw);
        }

        @Override
        public void render(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTick) {
            super.render(pGuiGraphics, mouseX, mouseY, partialTick);
            int x = (int)((double)(this.width / 2) - (double)super.getBgWidth() * 0.21);
            int y = (int)((float)(super.getBgStartY() + super.getBgHeight() / 2) + this.entry.getYOffset() * (float)super.getBgHeight());
            InventoryScreen.renderEntityInInventory((GuiGraphics)pGuiGraphics, (float)x, (float)y, (float)this.scale, (Vector3f)new Vector3f(), (Quaternionf)new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI), null, (LivingEntity)this.entity);
        }
    }

    public static class TimewornJournalImageEntryScreen
    extends BaseTimewornJournalEntryScreen {
        private final int scrollOffset;
        private final ImageEntry entry;
        private final boolean shouldRenderFrame;
        private final TimewornJournalScrollableScreen backScreen;

        public TimewornJournalImageEntryScreen(ImageEntry pEntry, boolean renderFrame, TimewornJournalScrollableScreen listScreen) {
            super(pEntry);
            this.scrollOffset = 0;
            this.entry = pEntry;
            this.shouldRenderFrame = renderFrame;
            this.backScreen = listScreen;
            this.backScreen.setScrollOffset(this.scrollOffset);
        }

        public TimewornJournalImageEntryScreen(ImageEntry pEntry, int pScrollOffset, boolean renderFrame, TimewornJournalScrollableScreen listScreen) {
            super(pEntry, pScrollOffset, listScreen);
            this.scrollOffset = pScrollOffset;
            this.entry = pEntry;
            this.shouldRenderFrame = renderFrame;
            this.backScreen = listScreen;
            this.backScreen.setScrollOffset(this.scrollOffset);
        }

        @Override
        protected void renderBackButton(@Nullable Screen pBackScreen) {
            this.addRenderableWidget((GuiEventListener)new ImageButton(super.getBgStartX() + 18, super.getBgStartY() + super.getBgHeight() - 36, 20, 20, BACK_BUTTON_SPRITES, p_308203_ -> this.minecraft.setScreen((Screen)this.backScreen)));
        }

        @Override
        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.render(guiGraphics, mouseX, mouseY, partialTick);
            if (this.entry != null) {
                ResourceLocation sprite = this.entry.getImage();
                if (this.shouldRenderFrame) {
                    super.renderImageFrame(guiGraphics);
                }
                super.renderItem(guiGraphics, sprite);
            }
        }
    }

    public static class TimewornJournalEmptyEntryScreen
    extends BaseTimewornJournalEntryScreen {
        private final int scrollOffset;
        private final TimewornJournalScrollableScreen backScreen;

        public TimewornJournalEmptyEntryScreen(BaseTimewornJournalEntry pEntry, TimewornJournalScrollableScreen listScreen) {
            super(pEntry);
            this.scrollOffset = 0;
            this.backScreen = listScreen;
            this.backScreen.setScrollOffset(this.scrollOffset);
        }

        public TimewornJournalEmptyEntryScreen(BaseTimewornJournalEntry pEntry, int pScrollOffset, TimewornJournalScrollableScreen listScreen) {
            super(pEntry, pScrollOffset, listScreen);
            this.scrollOffset = pScrollOffset;
            this.backScreen = listScreen;
            this.backScreen.setScrollOffset(this.scrollOffset);
        }

        @Override
        protected void renderBackButton(@Nullable Screen pBackScreen) {
            this.addRenderableWidget((GuiEventListener)new ImageButton(super.getBgStartX() + 18, super.getBgStartY() + super.getBgHeight() - 36, 20, 20, BACK_BUTTON_SPRITES, p_308203_ -> this.minecraft.setScreen((Screen)this.backScreen)));
        }
    }
}

