/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Function;
import net.je.common.block.ModBlocks;
import net.je.common.block.custom.EnderVaultBlock;
import net.je.common.block.entity.EnderVaultBlockEntity;
import net.je.common.entity.ModEntities;
import net.je.common.worldgen.ModStructurePieceTypes;
import net.je.common.worldgen.WardedBlockProcessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class ShadowTowerPiece
extends TemplateStructurePiece {
    public static final Codec<ShadowTowerPiece> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("template").forGetter(p -> ResourceLocation.parse((String)p.templateName)), (App)BlockPos.CODEC.fieldOf("pos").forGetter(TemplateStructurePiece::templatePosition), (App)Rotation.CODEC.fieldOf("rotation").forGetter(TemplateStructurePiece::getRotation)).apply((Applicative)instance, (templateId, pos, rotation) -> new ShadowTowerPiece((StructurePieceType)ModStructurePieceTypes.SHADOW_TOWER_PIECE.get(), (ResourceLocation)templateId, (BlockPos)pos, (Rotation)rotation)));
    private static final Map<Block, Block> BLOCK_MAP = Map.of((Block)ModBlocks.SHADOW_STONE_BRICKS.get(), (Block)ModBlocks.WARDED_SHADOW_STONE_BRICKS.get(), (Block)ModBlocks.SHADOW_STONE.get(), (Block)ModBlocks.WARDED_SHADOW_STONE.get(), (Block)ModBlocks.POLISHED_SHADOW_STONE.get(), (Block)ModBlocks.WARDED_POLISHED_SHADOW_STONE.get(), (Block)ModBlocks.CHISELED_SHADOW_STONE.get(), (Block)ModBlocks.WARDED_CHISELED_SHADOW_STONE.get(), (Block)ModBlocks.FADED_END_STONE_BRICKS.get(), (Block)ModBlocks.WARDED_FADED_END_STONE_BRICKS.get(), (Block)ModBlocks.VOIDGLASS.get(), (Block)ModBlocks.WARDED_VOIDGLASS.get());

    public ShadowTowerPiece(StructurePieceType type, ResourceLocation templateId, BlockPos pos, Rotation rotation, StructureTemplateManager templates) {
        super(type, 0, templates, templateId, templateId.toString(), ShadowTowerPiece.createSettings(rotation), pos);
    }

    public ShadowTowerPiece(StructurePieceType type, ResourceLocation templateId, BlockPos pos, Rotation rotation) {
        super(type, 0, null, templateId, templateId.toString(), ShadowTowerPiece.createSettings(rotation), pos);
    }

    public ShadowTowerPiece(StructurePieceType type, CompoundTag tag, StructureTemplateManager templateManager) {
        super(type, tag, templateManager, id -> new StructurePlaceSettings().setRotation(Rotation.NONE).setMirror(Mirror.NONE).addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_AND_AIR).addProcessor((StructureProcessor)new WardedBlockProcessor(BLOCK_MAP)).setIgnoreEntities(true));
    }

    public ShadowTowerPiece(StructurePieceType type, CompoundTag tag, StructureTemplateManager templates, Function<ResourceLocation, StructurePlaceSettings> settingsFactory) {
        super(type, tag, templates, settingsFactory);
    }

    private static StructurePlaceSettings createSettings(Rotation rotation) {
        System.out.println("postProcess called");
        return new StructurePlaceSettings().setRotation(rotation).setMirror(Mirror.NONE).setIgnoreEntities(true).addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK).addProcessor((StructureProcessor)new WardedBlockProcessor(BLOCK_MAP));
    }

    protected void handleDataMarker(String pName, BlockPos pPos, ServerLevelAccessor pLevel, RandomSource pRandom, BoundingBox pBox) {
        if (!pBox.isInside((Vec3i)pPos)) {
            return;
        }
        switch (pName) {
            case "je:ender_vault": {
                pLevel.setBlock(pPos, ((Block)ModBlocks.ENDER_VAULT.get()).defaultBlockState(), 2);
                break;
            }
            case "je:ender_vault_with_key": {
                pLevel.setBlock(pPos, (BlockState)((Block)ModBlocks.ENDER_VAULT.get()).defaultBlockState().setValue((Property)EnderVaultBlock.SHOULD_SPAWN_KEY, (Comparable)Boolean.valueOf(true)), 2);
                BlockEntity be = pLevel.getBlockEntity(pPos);
                if (!(be instanceof EnderVaultBlockEntity)) break;
                EnderVaultBlockEntity spawner = (EnderVaultBlockEntity)be;
                spawner.shouldSpawnKey = true;
                break;
            }
            case "je:shadow_lord_spawn": {
                Mob mob = (Mob)((EntityType)ModEntities.SHADOW_LORD.get()).create((Level)pLevel.getLevel());
                mob.moveTo((double)pPos.getX() + 0.5, (double)pPos.getY(), (double)pPos.getZ() + 0.5, 0.0f, 0.0f);
                mob.setPersistenceRequired();
                pLevel.addFreshEntity((Entity)mob);
            }
        }
    }

    public void postProcess(WorldGenLevel pLevel, StructureManager pStructureManager, ChunkGenerator pGenerator, RandomSource pRandom, BoundingBox pBox, ChunkPos pChunkPos, BlockPos pPos) {
        super.postProcess(pLevel, pStructureManager, pGenerator, pRandom, pBox, pChunkPos, pPos);
    }

    private void carveInterior(WorldGenLevel pLevel) {
        StructureTemplate template = this.template();
        StructurePlaceSettings settings = this.placeSettings;
        for (StructureTemplate.StructureBlockInfo blockInfo : template.filterBlocks(this.templatePosition, settings, Blocks.AIR)) {
            BlockPos worldPos = blockInfo.pos();
            BlockState state = blockInfo.state();
            pLevel.setBlock(worldPos, Blocks.AIR.defaultBlockState(), 2);
        }
    }

    private boolean isMarker(BlockState state) {
        return state.is(Blocks.BARRIER);
    }

    private void flattenArea(WorldGenLevel level, BlockPos start, Vec3i size) {
        int xSize = size.getX();
        int zSize = size.getZ();
        int yBase = start.getY();
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(start.getX() + dx, yBase, start.getZ() + dz);
                for (int groundY = yBase; groundY > level.getMinBuildHeight() && level.isEmptyBlock((BlockPos)checkPos.setY(groundY - 1)); --groundY) {
                }
                for (int fillY = groundY; fillY < yBase; ++fillY) {
                    level.setBlock((BlockPos)checkPos.setY(fillY), Blocks.END_STONE.defaultBlockState(), 2);
                }
            }
        }
    }
}

