/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.worldgen;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.je.common.block.ModBlocks;
import net.je.common.worldgen.ModStructurePieceTypes;
import net.je.common.worldgen.ModStructureTypes;
import net.je.common.worldgen.ShadowTowerPiece;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class ShadowTowerStructure
extends Structure {
    public static final MapCodec<ShadowTowerStructure> CODEC = ShadowTowerStructure.simpleCodec(ShadowTowerStructure::new);

    protected ShadowTowerStructure(Structure.StructureSettings pSettings) {
        super(pSettings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext pContext) {
        BlockPos chunkCenter = pContext.chunkPos().getMiddleBlockPosition(0);
        StructureTemplateManager templateManager = pContext.structureTemplateManager();
        ResourceLocation floor1Id = ResourceLocation.fromNamespaceAndPath((String)"je", (String)"shadow_tower/shadow_tower_2");
        StructureTemplate floor1Template = templateManager.getOrCreate(floor1Id);
        int width = floor1Template.getSize().getX();
        int length = floor1Template.getSize().getZ();
        int surfaceY = pContext.chunkGenerator().getBaseHeight(chunkCenter.getX(), chunkCenter.getZ(), Heightmap.Types.WORLD_SURFACE_WG, pContext.heightAccessor(), pContext.randomState());
        BlockPos startPos = new BlockPos(chunkCenter.getX(), surfaceY, chunkCenter.getZ());
        int startY = surfaceY - 15;
        for (int x = 0; x < width; x += 4) {
            for (int z = 0; z < length; z += 4) {
                int worldX = chunkCenter.getX() + x;
                int worldZ = chunkCenter.getZ() + z;
                int colHeight = pContext.chunkGenerator().getFirstOccupiedHeight(worldX, worldZ, Heightmap.Types.WORLD_SURFACE_WG, pContext.heightAccessor(), pContext.randomState());
                if (colHeight >= startY) continue;
                return Optional.empty();
            }
        }
        return Optional.of(new Structure.GenerationStub(startPos, builder -> {
            int yOffset = 5;
            for (int i = 1; i < 12; ++i) {
                ResourceLocation floorId = i == 3 ? ResourceLocation.fromNamespaceAndPath((String)"je", (String)"shadow_tower/shadow_tower_4_config_1") : ResourceLocation.fromNamespaceAndPath((String)"je", (String)("shadow_tower/shadow_tower_" + (i + 1)));
                StructureTemplate template = templateManager.getOrCreate(floorId);
                BlockPos placementPos = startPos.above(yOffset);
                builder.addPiece((StructurePiece)new ShadowTowerPiece((StructurePieceType)ModStructurePieceTypes.SHADOW_TOWER_PIECE.get(), floorId, placementPos, Rotation.NONE, templateManager));
                yOffset += template.getSize().getY();
            }
        }));
    }

    public void afterPlace(WorldGenLevel pLevel, StructureManager pStructureManager, ChunkGenerator pChunkGenerator, RandomSource pRandom, BoundingBox pBoundingBox, ChunkPos pChunkPos, PiecesContainer pPieces) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i = 31;
        BoundingBox boundingbox = pPieces.calculateBoundingBox();
        int j = boundingbox.minY();
        for (int k = pBoundingBox.minX(); k <= pBoundingBox.maxX(); ++k) {
            block1: for (int l = pBoundingBox.minZ(); l <= pBoundingBox.maxZ(); ++l) {
                blockpos$mutableblockpos.set(k, j, l);
                if (pLevel.isEmptyBlock((BlockPos)blockpos$mutableblockpos) || !boundingbox.isInside((Vec3i)blockpos$mutableblockpos) || !pPieces.isInsidePiece((BlockPos)blockpos$mutableblockpos)) continue;
                for (int i1 = j - 1; i1 > i; --i1) {
                    blockpos$mutableblockpos.setY(i1);
                    if (!pLevel.isEmptyBlock((BlockPos)blockpos$mutableblockpos) && !pLevel.getBlockState((BlockPos)blockpos$mutableblockpos).liquid()) continue block1;
                    pLevel.setBlock((BlockPos)blockpos$mutableblockpos, ((Block)ModBlocks.SHADOW_STONE_BRICKS.get()).defaultBlockState(), 2);
                }
            }
        }
    }

    public StructureType<?> type() {
        return (StructureType)ModStructureTypes.SHADOW_TOWER.get();
    }
}

