/*
 * Decompiled with CFR 0.152.
 */
package net.je.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.je.common.worldgen.ModStructureProcessors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.registries.ForgeRegistries;

public class WardedBlockProcessor
extends StructureProcessor {
    public static final MapCodec<WardedBlockProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)ForgeRegistries.BLOCKS.getCodec(), (Codec)ForgeRegistries.BLOCKS.getCodec()).fieldOf("replacements").forGetter(p -> p.replacementMap)).apply((Applicative)instance, WardedBlockProcessor::new));
    private final Map<Block, Block> replacementMap;

    public WardedBlockProcessor(Map<Block, Block> replacementMap) {
        this.replacementMap = replacementMap;
    }

    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos pos, BlockPos templatePos, StructureTemplate.StructureBlockInfo original, StructureTemplate.StructureBlockInfo current, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
        Block replacement = this.replacementMap.get(current.state().getBlock());
        if (replacement != null) {
            BlockState newState = replacement.defaultBlockState();
            System.out.println("processed");
            return new StructureTemplate.StructureBlockInfo(current.pos(), newState, current.nbt());
        }
        System.out.println("processed");
        return current;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)ModStructureProcessors.WARDED_BLOCK_PROCESSOR.get();
    }
}

