/*
 * Decompiled with CFR 0.152.
 */
package net.je.compat;

import java.util.ArrayList;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.je.common.block.ModBlocks;
import net.je.common.item.ModItems;
import net.je.common.recipe.EndStoneFurnaceRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class EndStoneFurnaceRecipeCategory
implements IRecipeCategory<EndStoneFurnaceRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"je", (String)"end_stone_furnace");
    public static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/furnace.png");
    public static final RecipeType<EndStoneFurnaceRecipe> END_STONE_FURNACE_RECIPE_TYPE = new RecipeType(UID, EndStoneFurnaceRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public EndStoneFurnaceRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 5, 5, 166, 75);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.END_STONE_FURNACE.get()));
    }

    public RecipeType<EndStoneFurnaceRecipe> getRecipeType() {
        return END_STONE_FURNACE_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.je.end_stone_furnace");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EndStoneFurnaceRecipe recipe, IFocusGroup focuses) {
        ItemStack voidblight = new ItemStack((ItemLike)ModItems.VOIDBLIGHT_BUCKET.get());
        ItemStack voidmass = new ItemStack((ItemLike)ModBlocks.VOIDMASS.get());
        ItemStack voidbloom = new ItemStack((ItemLike)ModBlocks.VOIDBLOOM.get());
        ArrayList<ItemStack> fuels = new ArrayList<ItemStack>();
        fuels.add(voidbloom);
        fuels.add(voidblight);
        fuels.add(voidmass);
        builder.addSlot(RecipeIngredientRole.INPUT, 51, 12).addIngredients((Ingredient)recipe.getIngredients().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 51, 48).addItemStacks(fuels);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 111, 30).addItemStack(recipe.getResultItem(null));
    }
}

