/*
 * Decompiled with CFR 0.152.
 */
package net.je.event;

import com.mojang.blaze3d.systems.RenderSystem;
import net.je.common.effect.ModEffects;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="je", value={Dist.CLIENT})
public class ModEventBusClientEvents {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"je", (String)"textures/misc/void_strike_overlay.png");

    @SubscribeEvent
    public static void customize(CustomizeGuiOverlayEvent pEvent) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        if (mc.player.getPersistentData().getBoolean("je:inside_shadow_block") && mc.options.getCameraType() == CameraType.FIRST_PERSON) {
            int width = mc.getWindow().getGuiScaledWidth();
            int height = mc.getWindow().getGuiScaledHeight();
            int alpha = 150;
            int red = 14;
            int green = 0;
            int blue = 31;
            int argb = alpha << 24 | red << 16 | green << 8 | blue;
            pEvent.getGuiGraphics().fill(0, 0, width, height, -100, argb);
        }
        ModEventBusClientEvents.voidblightOverlayInit(pEvent.getGuiGraphics(), mc);
    }

    private static void voidblightOverlayInit(GuiGraphics pGraphics, Minecraft mc) {
        Holder holder = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)ModEffects.VOID_STRIKE_EFFECT.get()));
        boolean isActive = mc.player.hasEffect(holder);
        if (isActive) {
            float alpha;
            if (!VoidStrikeOverlayState.wasActiveLastTick) {
                VoidStrikeOverlayState.fadeInTicks = 0;
                VoidStrikeOverlayState.fadeOutTicks = 0;
            }
            if (VoidStrikeOverlayState.fadeInTicks < 60) {
                alpha = (float)VoidStrikeOverlayState.fadeInTicks / 60.0f;
                ++VoidStrikeOverlayState.fadeInTicks;
            } else {
                alpha = 1.0f;
            }
            ModEventBusClientEvents.renderVoidblightOverlay(pGraphics, mc, alpha);
            VoidStrikeOverlayState.wasActiveLastTick = true;
        } else if (VoidStrikeOverlayState.wasActiveLastTick || VoidStrikeOverlayState.fadeOutTicks > 0) {
            VoidStrikeOverlayState.wasActiveLastTick = false;
            if (VoidStrikeOverlayState.fadeOutTicks == 0) {
                VoidStrikeOverlayState.fadeOutTicks = 60;
            }
            float alpha = (float)VoidStrikeOverlayState.fadeOutTicks / 60.0f;
            ModEventBusClientEvents.renderVoidblightOverlay(pGraphics, mc, alpha);
            --VoidStrikeOverlayState.fadeOutTicks;
        }
    }

    private static void renderVoidblightOverlay(GuiGraphics pGraphics, Minecraft mc, float alpha) {
        int width = mc.getWindow().getGuiScaledWidth();
        int height = mc.getWindow().getGuiScaledHeight();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.disableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        pGraphics.blit(TEXTURE, 0, 0, 0.0f, 0.0f, width, height, width, height);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    public static void renderShadowBlockOverlay(GuiGraphics pGraphics, Minecraft mc, float alpha) {
    }

    public class VoidStrikeOverlayState {
        public static int fadeOutTicks = 0;
        public static int fadeInTicks = 0;
        public static final int MAX_FADE_TICKS = 60;
        public static boolean wasActiveLastTick = false;
        public static boolean isFadingIn = false;

        public VoidStrikeOverlayState(ModEventBusClientEvents this$0) {
        }
    }
}

