/*
 * Decompiled with CFR 0.152.
 */
package net.je.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EndPortalBlock;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EndPortalBlock.class})
public class EndExitPortalMixin {
    @Inject(method={"getPortalDestination"}, at={@At(value="HEAD")}, cancellable=true)
    public void je$endPortalLogic(ServerLevel pLevel, Entity pEntity, BlockPos pPos, CallbackInfoReturnable<DimensionTransition> cir) {
        ServerLevel overworld;
        ServerPlayer player;
        if (pLevel.dimension() == Level.END && pEntity instanceof ServerPlayer && (player = (ServerPlayer)pEntity).getRespawnDimension() == Level.END && (overworld = pLevel.getServer().getLevel(Level.OVERWORLD)) != null) {
            Vec3 vec3 = pEntity.adjustSpawnLocation(overworld, overworld.getSharedSpawnPos()).getBottomCenter();
            cir.setReturnValue((Object)new DimensionTransition(overworld, vec3, pEntity.getDeltaMovement(), pEntity.getYRot(), pEntity.getXRot(), DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET)));
        }
    }
}

