/*
 * Decompiled with CFR 0.152.
 */
package net.je.mixin;

import java.util.Optional;
import javax.annotation.Nullable;
import net.je.common.block.custom.RespawnNexusBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin {
    @Shadow
    public abstract ServerLevel serverLevel();

    @Shadow
    @Nullable
    public abstract BlockPos getRespawnPosition();

    @Shadow
    public abstract ResourceKey<Level> getRespawnDimension();

    @Shadow
    public abstract float getRespawnAngle();

    @Inject(method={"findRespawnPositionAndUseSpawnBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectRespawn(boolean pKeepInventory, DimensionTransition.PostDimensionTransition pPostDimensionTransition, CallbackInfoReturnable<DimensionTransition> cir) {
        Block block;
        BlockState blockstate;
        ServerLevel level = this.serverLevel().getServer().getLevel(this.getRespawnDimension());
        BlockPos pos = this.getRespawnPosition();
        boolean isInExit = ((ServerPlayer)this).getPersistentData().getBoolean("je:in_end_exit");
        if (level != null && pos != null && !isInExit && (blockstate = level.getBlockState(this.getRespawnPosition())) != null && (block = blockstate.getBlock()) instanceof RespawnNexusBlock && ((Boolean)blockstate.getValue((Property)RespawnNexusBlock.CHARGED)).booleanValue() && RespawnNexusBlock.canSetSpawn((Level)level)) {
            Optional<Vec3> optional = RespawnNexusBlock.findStandUpPosition(EntityType.PLAYER, (CollisionGetter)level, pos);
            if (!pKeepInventory && optional.isPresent()) {
                level.setBlock(pos, (BlockState)blockstate.setValue((Property)RespawnNexusBlock.CHARGED, (Comparable)Boolean.valueOf(false)), 3);
            }
            if (optional.isPresent()) {
                cir.setReturnValue((Object)new DimensionTransition(level, optional.get(), Vec3.ZERO, this.getRespawnAngle(), 0.0f, pPostDimensionTransition));
            }
        }
    }
}

