/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.apothecary.effect;

import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.util.Objects;
import java.util.UUID;
import net.gobies.apothecary.config.CommonConfig;
import net.gobies.apothecary.init.AEffects;
import net.gobies.apothecary.util.ModLoadedUtil;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class MagicDrain
extends MobEffect {
    private static final UUID SPELL_POWER_UUID = UUID.randomUUID();

    public MagicDrain(MobEffectCategory category, int color) {
        super(category, color);
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if ((event.getSource().m_276093_(DamageTypes.f_268515_) || event.getSource().m_276093_(DamageTypes.f_268530_)) && attacker.m_21023_((MobEffect)AEffects.MagicDrain.get())) {
                int amplifier = Objects.requireNonNull(attacker.m_21124_((MobEffect)AEffects.MagicDrain.get())).m_19564_();
                float reducedDamage = (float)((double)event.getAmount() * (1.0 - (Double)CommonConfig.MAGIC_DRAIN_DECREASE.get() * (double)(amplifier + 1)));
                event.setAmount(reducedDamage);
            }
        }
    }

    public void m_6385_(@NotNull LivingEntity livingEntity, @NotNull AttributeMap attribute, int amplifier) {
        AttributeInstance spellPower;
        super.m_6385_(livingEntity, attribute, amplifier);
        if (ModLoadedUtil.isIronsSpellbooksLoaded() && (spellPower = livingEntity.m_21051_((Attribute)AttributeRegistry.SPELL_POWER.get())) != null && spellPower.m_22111_(SPELL_POWER_UUID) == null) {
            double power = (Double)CommonConfig.MAGIC_DRAIN_DECREASE.get() * (double)(amplifier + 1);
            spellPower.m_22125_(new AttributeModifier(SPELL_POWER_UUID, "Magic Drain", -power, AttributeModifier.Operation.ADDITION));
        }
    }

    public void m_6386_(@NotNull LivingEntity livingEntity, @NotNull AttributeMap attribute, int amplifier) {
        AttributeInstance spellPower;
        super.m_6386_(livingEntity, attribute, amplifier);
        if (ModLoadedUtil.isIronsSpellbooksLoaded() && (spellPower = livingEntity.m_21051_((Attribute)AttributeRegistry.SPELL_POWER.get())) != null && spellPower.m_22111_(SPELL_POWER_UUID) != null) {
            spellPower.m_22120_(SPELL_POWER_UUID);
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(MagicDrain.class);
    }
}

