/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.apothecary.event;

import java.util.List;
import net.gobies.apothecary.config.ClientConfig;
import net.gobies.apothecary.config.CommonConfig;
import net.gobies.apothecary.init.AEffects;
import net.gobies.apothecary.util.ModLoadedUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="apothecary", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEvents {
    @SubscribeEvent
    public static void onRenderTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        List effects = PotionUtils.m_43547_((ItemStack)stack);
        if (stack.m_41720_() instanceof PotionItem && !effects.isEmpty()) {
            if (((Boolean)ClientConfig.ENABLE_POTION_DESCRIPTIONS.get()).booleanValue()) {
                if (Screen.m_96638_()) {
                    potion.m_43488_().forEach(effect -> {
                        String potionDescription = effect.m_19544_().m_19481_();
                        event.getToolTip().add(Component.m_237115_((String)(potionDescription + ".description")).m_130940_(ChatFormatting.GRAY));
                    });
                } else {
                    event.getToolTip().add(Component.m_237115_((String)"tooltip.apothecary.potion_info").m_130940_(ChatFormatting.GRAY));
                }
            }
            if (((Boolean)ClientConfig.ADDITIONAL_POTION_TOOLTIPS.get()).booleanValue()) {
                int damageIncrease;
                int manaRegen;
                int spellPower;
                int arrowDamage;
                int armorToughness;
                int armor;
                int amplifier = ((MobEffectInstance)effects.get(0)).m_19564_();
                MobEffect getEffect = ((MobEffectInstance)potion.m_43488_().get(0)).m_19544_();
                if (getEffect == AEffects.IronSkin.get()) {
                    armor = (Integer)CommonConfig.IRON_SKIN_ARMOR_INCREASE.get() * (amplifier + 1);
                    ClientEvents.applyTooltips(event);
                    event.getToolTip().add(4, Component.m_237113_((String)("+" + armor + " Armor")).m_130940_(ChatFormatting.BLUE));
                }
                if (getEffect == AEffects.DiamondSkin.get()) {
                    armorToughness = (Integer)CommonConfig.DIAMOND_SKIN_ARMOR_INCREASE.get() * (amplifier + 1);
                    ClientEvents.applyTooltips(event);
                    event.getToolTip().add(4, Component.m_237113_((String)("+" + armorToughness + " Armor Toughness")).m_130940_(ChatFormatting.BLUE));
                }
                if (getEffect == AEffects.Archery.get()) {
                    arrowDamage = (Integer)CommonConfig.ARCHERY_DAMAGE_INCREASE.get() * (amplifier + 1);
                    ClientEvents.applyTooltips(event);
                    event.getToolTip().add(4, Component.m_237113_((String)("+" + arrowDamage + " Arrow Damage")).m_130940_(ChatFormatting.BLUE));
                }
                if (getEffect == AEffects.Reach.get()) {
                    int reach = (Integer)CommonConfig.REACH_INCREASE.get() * (amplifier + 1);
                    ClientEvents.applyTooltips(event);
                    event.getToolTip().add(4, Component.m_237113_((String)("+" + reach + " Entity Reach")).m_130940_(ChatFormatting.BLUE));
                    event.getToolTip().add(5, Component.m_237113_((String)("+" + reach + " Block Reach")).m_130940_(ChatFormatting.BLUE));
                }
                if (getEffect == AEffects.MagicPower.get() && ModLoadedUtil.isIronsSpellbooksLoaded()) {
                    spellPower = (int)(100.0 * (Double)CommonConfig.MAGIC_POWER_INCREASE.get() * (double)(amplifier + 1));
                    ClientEvents.applyTooltips(event);
                    event.getToolTip().add(4, Component.m_237113_((String)("+" + spellPower + "% Spell Power")).m_130940_(ChatFormatting.BLUE));
                }
                if (getEffect == AEffects.ManaRegeneration.get() && ModLoadedUtil.isIronsSpellbooksLoaded()) {
                    manaRegen = 25 * (amplifier + 1);
                    ClientEvents.applyTooltips(event);
                    event.getToolTip().add(4, Component.m_237113_((String)("+" + manaRegen + "% Mana Regeneration")).m_130940_(ChatFormatting.BLUE));
                }
                if (getEffect == AEffects.Spelunker.get()) {
                    int radius = 7 * (amplifier + 1);
                    ClientEvents.applyTooltips(event);
                    event.getToolTip().add(4, Component.m_237113_((String)("+" + radius + " Detection Radius")).m_130940_(ChatFormatting.BLUE));
                }
                if (getEffect == AEffects.Wrath.get()) {
                    damageIncrease = (int)(100.0 * (Double)CommonConfig.WRATH_DAMAGE_INCREASE.get() * (double)(amplifier + 1));
                    ClientEvents.applyTooltips(event);
                    event.getToolTip().add(4, Component.m_237113_((String)("+" + damageIncrease + "% Damage Increase")).m_130940_(ChatFormatting.BLUE));
                }
                if (getEffect == AEffects.Thorns.get()) {
                    int damageReflect = (int)(100.0 * (Double)CommonConfig.THORNS_DAMAGE_REFLECT.get() * (double)(amplifier + 1));
                    ClientEvents.applyTooltips(event);
                    event.getToolTip().add(4, Component.m_237113_((String)("+" + damageReflect + "% Damage Reflect")).m_130940_(ChatFormatting.BLUE));
                }
                if (getEffect == AEffects.BrokenArmor.get()) {
                    armor = (Integer)CommonConfig.BROKEN_ARMOR_ARMOR_DECREASE.get() * (amplifier + 1);
                    ClientEvents.applyTooltips(event);
                    event.getToolTip().add(4, Component.m_237113_((String)("-" + armor + " Armor")).m_130940_(ChatFormatting.RED));
                }
                if (getEffect == AEffects.RupturedArmor.get()) {
                    armorToughness = (Integer)CommonConfig.RUPTURED_ARMOR_ARMOR_DECREASE.get() * (amplifier + 1);
                    ClientEvents.applyTooltips(event);
                    event.getToolTip().add(4, Component.m_237113_((String)("-" + armorToughness + " Armor Toughness")).m_130940_(ChatFormatting.RED));
                }
                if (getEffect == AEffects.Misfire.get()) {
                    arrowDamage = (Integer)CommonConfig.MISFIRE_DAMAGE_DECREASE.get() * (amplifier + 1);
                    ClientEvents.applyTooltips(event);
                    event.getToolTip().add(4, Component.m_237113_((String)("-" + arrowDamage + " Arrow Damage")).m_130940_(ChatFormatting.RED));
                }
                if (getEffect == AEffects.Shocked.get()) {
                    int speed = (int)(100.0 * (Double)CommonConfig.SHOCKED_SPEED_DECREASE.get() * (double)(amplifier + 1));
                    ClientEvents.applyTooltips(event);
                    event.getToolTip().add(4, Component.m_237113_((String)("-" + speed + "% Speed")).m_130940_(ChatFormatting.RED));
                }
                if (getEffect == AEffects.MagicDrain.get() && ModLoadedUtil.isIronsSpellbooksLoaded()) {
                    spellPower = (int)(100.0 * (Double)CommonConfig.MAGIC_DRAIN_DECREASE.get() * (double)(amplifier + 1));
                    ClientEvents.applyTooltips(event);
                    event.getToolTip().add(4, Component.m_237113_((String)("-" + spellPower + "% Spell Power")).m_130940_(ChatFormatting.RED));
                }
                if (getEffect == AEffects.ManaExhaustion.get() && ModLoadedUtil.isIronsSpellbooksLoaded()) {
                    manaRegen = 25 * (amplifier + 1);
                    ClientEvents.applyTooltips(event);
                    event.getToolTip().add(4, Component.m_237113_((String)("-" + manaRegen + "% Mana Regeneration")).m_130940_(ChatFormatting.RED));
                }
                if (getEffect == AEffects.Feeble.get()) {
                    damageIncrease = (int)(100.0 * (Double)CommonConfig.FEEBLE_DAMAGE_DECREASE.get() * (double)(amplifier + 1));
                    ClientEvents.applyTooltips(event);
                    event.getToolTip().add(4, Component.m_237113_((String)("-" + damageIncrease + "% Damage Increase")).m_130940_(ChatFormatting.RED));
                }
            }
        }
    }

    private static void applyTooltips(ItemTooltipEvent event) {
        event.getToolTip().add(2, Component.m_237113_((String)""));
        event.getToolTip().add(3, Component.m_237113_((String)"When Applied:").m_130940_(ChatFormatting.DARK_PURPLE));
    }
}

