/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.apothecary.event;

import net.gobies.apothecary.config.CommonConfig;
import net.gobies.apothecary.init.AEffects;
import net.gobies.apothecary.util.DurationUtils;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="apothecary")
public class WorldEvents {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        Entity mob = event.getSource().m_7639_();
        if (entity != null && ((Boolean)CommonConfig.ENABLE_WORLD_EVENTS.get()).booleanValue()) {
            int newAmplifier;
            float damageAmount = event.getAmount();
            int randomMediumDuration = DurationUtils.getRandomMediumDuration();
            int randomShortDuration = DurationUtils.getRandomShortDuration();
            int randomVeryShortDuration = DurationUtils.getRandomVeryShortDuration();
            int randomLongDuration = DurationUtils.getRandomLongDuration();
            int baseAmplifier = 0;
            int rangedAmplifier = (double)entity.m_217043_().m_188501_() < 0.75 ? 0 : 1;
            MobEffectInstance currentEffect = entity.m_21124_((MobEffect)AEffects.BrokenArmor.get());
            int n = newAmplifier = currentEffect != null ? currentEffect.m_19564_() + 1 : 0;
            if ((event.getSource().m_276093_(DamageTypes.f_268565_) || event.getSource().m_276093_(DamageTypes.f_268448_)) && entity.m_21230_() > 0) {
                if ((double)entity.m_217043_().m_188501_() < 0.4) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)AEffects.BrokenArmor.get(), randomLongDuration, newAmplifier));
                }
                if ((double)damageAmount > 5.0) {
                    currentEffect = entity.m_21124_((MobEffect)AEffects.RupturedArmor.get());
                    int n2 = newAmplifier = currentEffect != null ? currentEffect.m_19564_() + 1 : 0;
                    if ((double)entity.m_217043_().m_188501_() < 0.1) {
                        entity.m_7292_(new MobEffectInstance((MobEffect)AEffects.RupturedArmor.get(), randomMediumDuration, newAmplifier));
                    }
                }
            }
            if (event.getSource().m_276093_(DamageTypes.f_268450_)) {
                entity.m_7292_(new MobEffectInstance((MobEffect)AEffects.Shocked.get(), randomVeryShortDuration, rangedAmplifier));
            }
            if (mob instanceof Mob && ((Mob)mob).m_5912_()) {
                currentEffect = entity.m_21124_((MobEffect)AEffects.Feeble.get());
                int n3 = newAmplifier = currentEffect != null ? currentEffect.m_19564_() + 1 : 0;
                if ((double)entity.m_217043_().m_188501_() < 0.05) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)AEffects.Feeble.get(), randomMediumDuration, newAmplifier));
                }
            }
            if (mob instanceof PiglinBrute) {
                currentEffect = entity.m_21124_((MobEffect)AEffects.RupturedArmor.get());
                int n4 = newAmplifier = currentEffect != null ? Math.min(currentEffect.m_19564_() + 1, 4) : 0;
                if (entity.m_21230_() > 0) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)AEffects.RupturedArmor.get(), randomShortDuration, newAmplifier));
                }
            }
            if (mob instanceof Blaze && (double)entity.m_217043_().m_188501_() < 0.25) {
                entity.m_7292_(new MobEffectInstance((MobEffect)AEffects.Burning.get(), randomShortDuration, baseAmplifier));
            }
            if (mob instanceof Illusioner && (double)entity.m_217043_().m_188501_() < 0.1) {
                entity.m_7292_(new MobEffectInstance((MobEffect)AEffects.Confusion.get(), randomShortDuration, baseAmplifier));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingAttackEvent event) {
    }

    static {
        MinecraftForge.EVENT_BUS.register(WorldEvents.class);
    }
}

