/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.apothecary.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ShuffleInventoryPacket {
    private final List<ItemStack> shuffledInventory;

    public ShuffleInventoryPacket(List<ItemStack> shuffledInventory) {
        this.shuffledInventory = shuffledInventory;
    }

    public ShuffleInventoryPacket(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        this.shuffledInventory = new ArrayList<ItemStack>();
        for (int i = 0; i < size; ++i) {
            this.shuffledInventory.add(buffer.m_130267_());
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.shuffledInventory.size());
        for (ItemStack itemStack : this.shuffledInventory) {
            buffer.m_130055_(itemStack);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                this.shufflePlayerInventory((Player)player);
            }
        });
        context.setPacketHandled(true);
    }

    private void shufflePlayerInventory(Player player) {
        int inventoryIndex = 0;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            if (i >= 36 && i <= 39) continue;
            player.m_150109_().m_6836_(i, this.shuffledInventory.get(inventoryIndex));
            ++inventoryIndex;
        }
        player.m_150109_().m_6596_();
        player.f_36096_.m_38946_();
    }
}

