/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.apothecary.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.gobies.apothecary.config.CommonConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class BlacklistedEffects {
    private static Set<ResourceLocation> PURIFICATION_BLACKLISTED_EFFECTS = null;
    private static Set<ResourceLocation> CORRUPTION_BLACKLISTED_EFFECTS = null;

    public static void initCleansedBlacklist() {
        if (PURIFICATION_BLACKLISTED_EFFECTS == null) {
            PURIFICATION_BLACKLISTED_EFFECTS = new HashSet<ResourceLocation>();
            for (String effects : (List)CommonConfig.PURIFICATION_BLACKLIST_EFFECTS.get()) {
                PURIFICATION_BLACKLISTED_EFFECTS.add(new ResourceLocation(effects));
            }
        }
    }

    public static boolean isHarmfulEffectBlacklisted(MobEffect effect) {
        ResourceLocation effectRegistryName;
        if (PURIFICATION_BLACKLISTED_EFFECTS == null) {
            BlacklistedEffects.initCleansedBlacklist();
        }
        return (effectRegistryName = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect)) == null || !PURIFICATION_BLACKLISTED_EFFECTS.contains(effectRegistryName);
    }

    public static boolean isHarmfulEffectApplicable(LivingEntity ignoredEntity, MobEffectInstance effectInstance) {
        MobEffect effect = effectInstance.m_19544_();
        return effect.m_19483_() == MobEffectCategory.HARMFUL && BlacklistedEffects.isHarmfulEffectBlacklisted(effect);
    }

    public static void initCorruptedBlacklist() {
        if (CORRUPTION_BLACKLISTED_EFFECTS == null) {
            CORRUPTION_BLACKLISTED_EFFECTS = new HashSet<ResourceLocation>();
            for (String effects : (List)CommonConfig.CORRUPTION_BLACKLIST_EFFECTS.get()) {
                CORRUPTION_BLACKLISTED_EFFECTS.add(new ResourceLocation(effects));
            }
        }
    }

    public static boolean isBeneficialEffectBlacklisted(MobEffect effect) {
        ResourceLocation effectRegistryName;
        if (CORRUPTION_BLACKLISTED_EFFECTS == null) {
            BlacklistedEffects.initCorruptedBlacklist();
        }
        return (effectRegistryName = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect)) == null || !CORRUPTION_BLACKLISTED_EFFECTS.contains(effectRegistryName);
    }

    public static boolean isBeneficialEffectApplicable(LivingEntity ignoredEntity, MobEffectInstance effectInstance) {
        MobEffect effect = effectInstance.m_19544_();
        return effect.m_19483_() == MobEffectCategory.BENEFICIAL && BlacklistedEffects.isBeneficialEffectBlacklisted(effect);
    }
}

