/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.data.hypixel;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.data.hypixel.HypixelAPIFixer;
import fr.siroz.cariboustonks.core.data.hypixel.HypixelDataException;
import fr.siroz.cariboustonks.core.data.hypixel.SkyBlockItem;
import fr.siroz.cariboustonks.core.data.hypixel.bazaar.Product;
import fr.siroz.cariboustonks.core.data.hypixel.reply.SkyBlockBazaarReply;
import fr.siroz.cariboustonks.core.data.hypixel.reply.SkyBlockItemsReply;
import fr.siroz.cariboustonks.core.data.mod.ModDataSource;
import fr.siroz.cariboustonks.core.json.GsonProvider;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.util.ItemUtils;
import fr.siroz.cariboustonks.util.http.Http;
import fr.siroz.cariboustonks.util.http.HttpResponse;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_9334;
import org.apache.http.client.HttpResponseException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class HypixelDataSource {
    private static final String ITEMS_API = "https://api.hypixel.net/v2/resources/skyblock/items";
    private final Object2ObjectMap<String, SkyBlockItem> skyBlockItems = new Object2ObjectOpenHashMap();
    private static final String BAZAAR_API = "https://api.hypixel.net/v2/skyblock/bazaar";
    private Object2ObjectMap<String, Product> bazaarData = new Object2ObjectOpenHashMap();
    private final HypixelAPIFixer apiFixer = new HypixelAPIFixer();
    private final ModDataSource modDataSource;
    private boolean skyBlockItemError = false;
    private boolean bazaarUpdateError = false;
    private boolean bazaarInUpdate = false;
    private boolean itemsLoaded = false;
    private boolean firstBazaarUpdated = false;
    private boolean hasCalledFixMissing = false;

    @ApiStatus.Internal
    public HypixelDataSource(@NotNull ModDataSource modDataSource) {
        this.modDataSource = modDataSource;
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> this.onClientStarted());
    }

    private void onClientStarted() {
        this.loadItems().thenRun(() -> {
            this.itemsLoaded = true;
            this.checkItemsResults();
            this.fixMissingSkyBlockItems();
        });
        TickScheduler.getInstance().runRepeating(() -> {
            if (ConfigManager.getConfig().general.stonks.bazaarTooltipPrice) {
                this.updateBazaar().thenRun(() -> {
                    this.bazaarInUpdate = false;
                    this.bazaarUpdateError = false;
                    if (!this.firstBazaarUpdated) {
                        this.firstBazaarUpdated = true;
                        this.checkBazaarResult();
                        this.fixMissingSkyBlockItems();
                    } else {
                        this.checkBazaarResult();
                    }
                });
            }
        }, 5, TimeUnit.MINUTES);
    }

    @NotNull
    public class_1799 getItemStack(@NotNull String skyBlockItemId) {
        class_1799 fallback = new class_1799((class_1935)class_1802.field_8077, 1);
        fallback.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)skyBlockItemId));
        if (this.modDataSource.isItemsMappingError()) {
            return fallback;
        }
        try {
            SkyBlockItem skyBlockItem = (SkyBlockItem)this.skyBlockItems.get((Object)skyBlockItemId);
            if (skyBlockItem == null) {
                return fallback;
            }
            String hypixelMaterial = skyBlockItem.getMaterial();
            String minecraftId = this.modDataSource.getMinecraftId(hypixelMaterial);
            if (minecraftId == null || minecraftId.equals("NO_MATCH")) {
                return fallback;
            }
            class_1799 itemStack = new class_1799((class_1935)class_1802.field_8077, 1);
            Optional<class_1792> item = ItemUtils.getItemById(minecraftId);
            if (item.isPresent()) {
                itemStack = new class_1799((class_1935)item.get(), 1);
            }
            if (skyBlockItem.isSkullItem() && skyBlockItem.getSkullTexture().isPresent()) {
                itemStack = ItemUtils.createSkull(skyBlockItem.getSkullTexture().get());
            }
            itemStack.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)skyBlockItemId));
            return itemStack;
        }
        catch (Throwable ex) {
            CaribouStonks.LOGGER.warn("[HypixelDataSource] Unable to create ItemStack for {}", (Object)skyBlockItemId, (Object)ex);
            return fallback;
        }
    }

    @Nullable
    public SkyBlockItem getSkyBlockItem(@Nullable String skyBlockItemId) {
        if (skyBlockItemId == null || skyBlockItemId.isEmpty()) {
            return null;
        }
        return (SkyBlockItem)this.skyBlockItems.get((Object)skyBlockItemId);
    }

    public Optional<SkyBlockItem> getSkyBlockItemOptional(@Nullable String skyBlockItemId) {
        SkyBlockItem item = this.getSkyBlockItem(skyBlockItemId);
        return item == null ? Optional.empty() : Optional.of(item);
    }

    @NotNull
    public @Unmodifiable List<SkyBlockItem> getSkyBlockItems() throws HypixelDataException {
        if (this.modDataSource.isItemsMappingError()) {
            throw new HypixelDataException(class_2561.method_30163((String)"Unable to map SkyBlock Items into Minecraft."));
        }
        if (this.skyBlockItemError) {
            throw new HypixelDataException(class_2561.method_30163((String)"Unable to fetch SkyBlock Items from Hypixel API."));
        }
        if (this.skyBlockItems.isEmpty()) {
            throw new HypixelDataException(class_2561.method_30163((String)"No SkyBlock Items is registered."));
        }
        return new ArrayList<SkyBlockItem>((Collection<SkyBlockItem>)this.skyBlockItems.values());
    }

    @Contract(value=" -> new")
    @NotNull
    public Set<String> getSkyBlockItemsIds() {
        return new HashSet<String>((Collection<String>)this.skyBlockItems.keySet());
    }

    public int getSkyBlockItemCounts() {
        return this.skyBlockItems.size();
    }

    public boolean isBazaarInUpdate() {
        return this.bazaarInUpdate;
    }

    public boolean hasBazaarItem(@Nullable String skyBlockItemId) {
        if (skyBlockItemId == null || skyBlockItemId.isEmpty()) {
            return false;
        }
        return this.bazaarData.containsKey((Object)skyBlockItemId);
    }

    public Optional<Product> getBazaarItem(@Nullable String skyBlockItemId) {
        if (this.bazaarData == null || skyBlockItemId == null || skyBlockItemId.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable((Product)this.bazaarData.get((Object)skyBlockItemId));
    }

    @NotNull
    private CompletableFuture<Void> loadItems() {
        CaribouStonks.LOGGER.info("[HypixelDataSource] Loading SkyBlock Items..");
        return this.fetchSkyBlockItems().thenAccept(reply -> {
            if (reply.getResponse() == null) {
                this.skyBlockItemError = true;
                return;
            }
            try {
                JsonArray array = reply.getResponse().get("items").getAsJsonArray();
                for (int i = 0; i < array.size(); ++i) {
                    String id;
                    JsonObject item = array.get(i).getAsJsonObject();
                    if (!item.has("id") || this.apiFixer.isBlacklisted(id = item.get("id").getAsString())) continue;
                    try {
                        SkyBlockItem skyBlockItem = new SkyBlockItem(item);
                        this.skyBlockItems.put((Object)id, (Object)skyBlockItem);
                        continue;
                    }
                    catch (Exception ex) {
                        CaribouStonks.LOGGER.error("[CaribouStonks HypixelData] Unable to parse SkyBlock Item: {}", (Object)id, (Object)ex);
                    }
                }
            }
            catch (Throwable ex) {
                this.skyBlockItemError = true;
                CaribouStonks.LOGGER.error("[HypixelDataSource] There was an error while loading SkyBlock Items", ex);
            }
        });
    }

    @NotNull
    private CompletableFuture<Void> updateBazaar() {
        CaribouStonks.LOGGER.info("[HypixelDataSource] Updating SkyBlock Bazaar..");
        this.bazaarInUpdate = true;
        return this.fetchBazaar().thenAccept(reply -> {
            if (reply == null) {
                this.bazaarUpdateError = true;
                return;
            }
            if (reply.getProducts() == null || reply.getProducts().isEmpty()) {
                this.bazaarUpdateError = true;
                return;
            }
            this.bazaarData = new Object2ObjectOpenHashMap(reply.getProducts());
        });
    }

    @Contract(value=" -> new")
    @NotNull
    private CompletableFuture<SkyBlockItemsReply> fetchSkyBlockItems() {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse response = Http.request(ITEMS_API);
            try {
                if (!response.success()) {
                    throw new HttpResponseException(response.statusCode(), response.content());
                }
                SkyBlockItemsReply reply = new SkyBlockItemsReply((JsonObject)GsonProvider.standard().fromJson(response.content(), JsonObject.class));
                if (!reply.isSuccess()) {
                    throw new RuntimeException("SkyBlock Resource Items reply failed: " + reply.getCause());
                }
                SkyBlockItemsReply skyBlockItemsReply = reply;
                if (response != null) {
                    response.close();
                }
                return skyBlockItemsReply;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable ex) {
                    CaribouStonks.LOGGER.error("[HypixelDataSource] Failed to fetch SkyBlock Items from Hypixel API", ex);
                    return null;
                }
            }
        });
    }

    @Contract(value=" -> new")
    @NotNull
    private CompletableFuture<SkyBlockBazaarReply> fetchBazaar() {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse response = Http.request(BAZAAR_API);
            try {
                if (!response.success()) {
                    throw new HttpResponseException(response.statusCode(), response.content());
                }
                SkyBlockBazaarReply reply = (SkyBlockBazaarReply)GsonProvider.prettyPrinting().fromJson(response.content(), SkyBlockBazaarReply.class);
                if (reply == null) {
                    throw new IllegalStateException("Json is null or empty");
                }
                if (!reply.isSuccess()) {
                    throw new RuntimeException("SkyBlock Bazaar reply failed: " + reply.getCause());
                }
                SkyBlockBazaarReply skyBlockBazaarReply = reply;
                if (response != null) {
                    response.close();
                }
                return skyBlockBazaarReply;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable ex) {
                    CaribouStonks.LOGGER.error("[HypixelDataSource] Failed to fetch SkyBlock Bazaar from Hypixel API", ex);
                    return null;
                }
            }
        });
    }

    private void checkItemsResults() {
        if (!this.skyBlockItemError) {
            CaribouStonks.LOGGER.info("[HypixelDataSource] Loaded {} SkyBlock Items", (Object)this.skyBlockItems.size());
        } else {
            CaribouStonks.LOGGER.error("[HypixelDataSource] Unable to load SkyBlock Items from Hypixel API");
        }
        if (!this.skyBlockItemError && !this.modDataSource.isItemsMappingError()) {
            List hypixelMaterials = this.skyBlockItems.values().stream().map(SkyBlockItem::getMaterial).collect(Collectors.toSet()).stream().toList();
            for (String material : hypixelMaterials) {
                if (this.modDataSource.containsItem(material)) continue;
                CaribouStonks.LOGGER.warn("[HypixelDataSource] (Minecraft Ids Mapping) -> {} is not registered!", (Object)material);
            }
        } else {
            CaribouStonks.LOGGER.error("[HypixelDataSource] (Minecraft Ids Mapping) SkyBlock Items error or mapping error");
        }
    }

    private void checkBazaarResult() {
        if (!this.bazaarUpdateError) {
            CaribouStonks.LOGGER.info("[HypixelDataSource] Updated {} Bazaar Items", (Object)this.bazaarData.size());
        } else {
            CaribouStonks.LOGGER.error("[HypixelDataSource] Unable to update Bazaar Items from Hypixel API");
        }
    }

    private void fixMissingSkyBlockItems() {
        if (this.itemsLoaded && this.firstBazaarUpdated && !this.hasCalledFixMissing) {
            this.hasCalledFixMissing = true;
            CaribouStonks.LOGGER.info("[HypixelDataSource] Fixing Hypixel SkyBlock Items..");
            int fixedEnchants = 0;
            int fixedEssences = 0;
            int fixedShards = 0;
            for (String bazaarProductId : this.bazaarData.keySet()) {
                if (this.skyBlockItems.containsKey((Object)bazaarProductId)) continue;
                try {
                    if (this.apiFixer.isEnchantment(bazaarProductId)) {
                        this.skyBlockItems.put((Object)bazaarProductId, (Object)this.apiFixer.createEnchant(bazaarProductId));
                        ++fixedEnchants;
                        continue;
                    }
                    if (this.apiFixer.isEssence(bazaarProductId)) {
                        this.skyBlockItems.put((Object)bazaarProductId, (Object)this.apiFixer.createEssence(bazaarProductId));
                        ++fixedEssences;
                        continue;
                    }
                    if (this.apiFixer.isShard(bazaarProductId)) {
                        SkyBlockItem shard = this.apiFixer.createShard(bazaarProductId);
                        if (shard != null) {
                            this.skyBlockItems.put((Object)bazaarProductId, (Object)shard);
                            ++fixedShards;
                            continue;
                        }
                        CaribouStonks.LOGGER.warn("[HypixelDataSource] Unable to create {} Shard! Not registered in ModDataSource.", (Object)bazaarProductId);
                        continue;
                    }
                    CaribouStonks.LOGGER.warn("[HypixelDataSource] Unable to fix {}. Not identified!", (Object)bazaarProductId);
                }
                catch (Throwable ex) {
                    CaribouStonks.LOGGER.error("[HypixelDataSource] Fix for {} failed", (Object)bazaarProductId, (Object)ex);
                }
            }
            CaribouStonks.LOGGER.info("[HypixelDataSource] Fixed {} enchants, {} essences and {} Shards from Bazaar to SkyBlock Items", new Object[]{fixedEnchants, fixedEssences, fixedShards});
        }
    }
}

