/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.data.hypixel;

import com.google.gson.JsonObject;
import fr.siroz.cariboustonks.core.skyblock.Rarity;
import java.util.Optional;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class SkyBlockItem {
    private final String skyBlockId;
    private final String material;
    private final String name;
    private final Rarity tier;
    private String skullTexture;
    private boolean skullItem = false;

    public SkyBlockItem(String skyBlockId, String material, String name, Rarity tier) {
        this.skyBlockId = skyBlockId;
        this.material = material;
        this.name = name;
        this.tier = tier;
    }

    public SkyBlockItem(@NotNull JsonObject jsonItem) throws NullPointerException, UnsupportedOperationException, IllegalStateException {
        this.skyBlockId = jsonItem.get("id").getAsString();
        this.material = jsonItem.get("material").getAsString();
        this.name = jsonItem.get("name").getAsString();
        String tierString = null;
        if (jsonItem.has("tier")) {
            tierString = jsonItem.get("tier").getAsString();
        }
        this.tier = Rarity.fromName(tierString);
        if (jsonItem.has("skin") && this.material.equals("SKULL_ITEM")) {
            JsonObject skin = jsonItem.get("skin").getAsJsonObject();
            this.skullTexture = skin.get("value").getAsString();
            this.skullItem = true;
        }
    }

    public String getSkyBlockId() {
        return this.skyBlockId;
    }

    public String getMaterial() {
        return this.material;
    }

    public String getName() {
        return this.name;
    }

    public Rarity getTier() {
        return this.tier;
    }

    public boolean isSkullItem() {
        return this.skullItem;
    }

    @Contract(pure=true)
    @NotNull
    public Optional<String> getSkullTexture() {
        return Optional.ofNullable(this.skullTexture);
    }
}

