/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.core.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.core.json.GsonProvider;
import fr.siroz.cariboustonks.core.json.JsonProcessingException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonFileService {
    private final Gson gson;

    @ApiStatus.Internal
    public JsonFileService() {
        this.gson = GsonProvider.prettyPrinting();
    }

    @ApiStatus.Internal
    public JsonFileService(@NotNull Gson gson) {
        this.gson = gson;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public <T> T load(@NotNull Path path, @NotNull Class<T> clazz) {
        if (Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Object object = this.gson.fromJson((Reader)reader, clazz);
            return (T)object;
        }
        catch (JsonParseException | IOException ex) {
            CaribouStonks.LOGGER.error("[JsonFileService] Unable to load file: {}", (Object)path, (Object)ex);
            return null;
        }
    }

    public void save(@NotNull Path path, @NotNull Object object) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            this.gson.toJson(object, (Appendable)writer);
        }
        catch (IOException ex) {
            CaribouStonks.LOGGER.error("[JsonFileService] Unable to save file: {}", (Object)path, (Object)ex);
            throw new JsonProcessingException("Error occurred while saving the list to file: " + String.valueOf(path), ex);
        }
    }

    @Deprecated
    @NotNull
    public <T> List<T> loadList(@NotNull Path path, @NotNull Function<JsonObject, T> deserializer) {
        block11: {
            ArrayList<T> arrayList;
            block10: {
                BufferedReader reader2 = Files.newBufferedReader(path);
                try {
                    JsonArray jsonArray = JsonParser.parseReader((Reader)reader2).getAsJsonArray();
                    ArrayList<T> objects = new ArrayList<T>();
                    for (JsonElement element : jsonArray) {
                        JsonObject objJson = element.getAsJsonObject();
                        T obj = deserializer.apply(objJson);
                        if (obj == null) continue;
                        objects.add(obj);
                    }
                    arrayList = objects;
                    if (reader2 == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader2 != null) {
                            try {
                                reader2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NoSuchFileException reader2) {
                        break block11;
                    }
                    catch (JsonParseException | IOException ex) {
                        CaribouStonks.LOGGER.error("[JsonFileService] Unable to load list from file: {}", (Object)path, (Object)ex);
                    }
                }
                reader2.close();
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    @NotNull
    public <T> List<T> loadList(@NotNull Path path, @NotNull Class<T> clazz) {
        List list;
        block9: {
            if (Files.notExists(path, new LinkOption[0])) {
                return Collections.emptyList();
            }
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                Type listType = TypeToken.getParameterized(List.class, (Type[])new Type[]{clazz}).getType();
                list = (List)this.gson.fromJson((Reader)reader, listType);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonSyntaxException | IOException ex) {
                    CaribouStonks.LOGGER.error("[JsonFileService] Unable to load list from file: {}", (Object)path, (Object)ex);
                    throw new JsonProcessingException("Error occurred while loading the list from file: " + String.valueOf(path), ex);
                }
            }
            reader.close();
        }
        return list;
    }

    @NotNull
    public <K, V> Map<K, V> loadMap(@NotNull Path path, @NotNull Type typeOfMap) {
        Map map;
        block9: {
            if (Files.notExists(path, new LinkOption[0])) {
                return Collections.emptyMap();
            }
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                map = (Map)this.gson.fromJson((Reader)reader, typeOfMap);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonSyntaxException | IOException ex) {
                    CaribouStonks.LOGGER.error("[JsonFileService] Unable to load map from file: {}", (Object)path, (Object)ex);
                    throw new JsonProcessingException("Error occurred while loading the map from file: " + String.valueOf(path), ex);
                }
            }
            reader.close();
        }
        return map;
    }

    @NotNull
    public <K, V> Map<K, V> loadMap(@NotNull Path path, @NotNull Class<K> keyClass, @NotNull Class<V> valueClass) {
        Map map;
        block9: {
            if (Files.notExists(path, new LinkOption[0])) {
                return Collections.emptyMap();
            }
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                Type mapType = TypeToken.getParameterized(Map.class, (Type[])new Type[]{keyClass, valueClass}).getType();
                map = (Map)this.gson.fromJson((Reader)reader, mapType);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonSyntaxException | IOException ex) {
                    CaribouStonks.LOGGER.error("[JsonFileService] Unable to load map from file: {}", (Object)path, (Object)ex);
                    throw new JsonProcessingException("Error occurred while loading the map from file: " + String.valueOf(path), ex);
                }
            }
            reader.close();
        }
        return map;
    }
}

