/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.event;

import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.manager.slayer.SlayerTier;
import fr.siroz.cariboustonks.manager.slayer.SlayerType;
import java.time.Instant;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SkyBlockEvents {
    public static final Event<Join> JOIN = EventFactory.createArrayBacked(Join.class, listeners -> serverName -> {
        for (Join listener : listeners) {
            listener.onJoin(serverName);
        }
    });
    public static final Event<Leave> LEAVE = EventFactory.createArrayBacked(Leave.class, listeners -> () -> {
        for (Leave listener : listeners) {
            listener.onLeave();
        }
    });
    public static final Event<IslandChange> ISLAND_CHANGE = EventFactory.createArrayBacked(IslandChange.class, listeners -> location -> {
        for (IslandChange listener : listeners) {
            listener.onIslandChange(location);
        }
    });
    public static final Event<SlayerBossSpawn> SLAYER_BOSS_SPAWN = EventFactory.createArrayBacked(SlayerBossSpawn.class, listeners -> (type, tier) -> {
        for (SlayerBossSpawn listener : listeners) {
            listener.onSpawn(type, tier);
        }
    });
    public static final Event<SlayerMinibossSpawn> SLAYER_MINIBOSS_SPAWN = EventFactory.createArrayBacked(SlayerMinibossSpawn.class, listeners -> (type, tier) -> {
        for (SlayerMinibossSpawn listener : listeners) {
            listener.onSpawn(type, tier);
        }
    });
    public static final Event<SlayerBossDeath> SLAYER_BOSS_DEATH = EventFactory.createArrayBacked(SlayerBossDeath.class, listeners -> (type, tier, instant) -> {
        for (SlayerBossDeath listener : listeners) {
            listener.onDeath(type, tier, instant);
        }
    });
    public static final Event<SlayerQuestStart> SLAYER_QUEST_START = EventFactory.createArrayBacked(SlayerQuestStart.class, listeners -> (type, tier, afterUpdate) -> {
        for (SlayerQuestStart listener : listeners) {
            listener.onStart(type, tier, afterUpdate);
        }
    });
    public static final Event<SlayerQuestFail> SLAYER_QUEST_FAIL = EventFactory.createArrayBacked(SlayerQuestFail.class, listeners -> (type, tier) -> {
        for (SlayerQuestFail listener : listeners) {
            listener.onFail(type, tier);
        }
    });

    private SkyBlockEvents() {
    }

    @FunctionalInterface
    public static interface SlayerQuestFail {
        public void onFail(@NotNull SlayerType var1, @NotNull SlayerTier var2);
    }

    @FunctionalInterface
    public static interface SlayerQuestStart {
        public void onStart(@NotNull SlayerType var1, @NotNull SlayerTier var2, boolean var3);
    }

    @FunctionalInterface
    public static interface SlayerBossDeath {
        public void onDeath(@NotNull SlayerType var1, @NotNull SlayerTier var2, @Nullable Instant var3);
    }

    @FunctionalInterface
    public static interface SlayerMinibossSpawn {
        public void onSpawn(@NotNull SlayerType var1, @NotNull SlayerTier var2);
    }

    @FunctionalInterface
    public static interface SlayerBossSpawn {
        public void onSpawn(@NotNull SlayerType var1, @NotNull SlayerTier var2);
    }

    @FunctionalInterface
    public static interface IslandChange {
        public void onIslandChange(@NotNull IslandType var1);
    }

    @FunctionalInterface
    public static interface Leave {
        public void onLeave();
    }

    @FunctionalInterface
    public static interface Join {
        public void onJoin(@NotNull String var1);
    }
}

