/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.combat;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.NetworkEvents;
import fr.siroz.cariboustonks.event.WorldEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.manager.slayer.SlayerManager;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.ItemUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class CocoonedWarningFeature
extends Feature {
    private static final long WORLD_CHANGE_THRESHOLD = 10000L;
    private static final double MAX_DISTANCE_SQ = 4.0;
    private final SlayerManager slayerManager;
    private final Deque<class_1531> chain = new ArrayDeque<class_1531>();
    private long lastWorldChange = 0L;

    public CocoonedWarningFeature(SlayerManager slayerManager) {
        this.slayerManager = slayerManager;
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register(this::onChangeWorld);
        NetworkEvents.ARMORSTAND_UPDATE_PACKET.register(this::onUpdateArmorStand);
        WorldEvents.ARMORSTAND_REMOVED.register(this::onRemoveArmorStand);
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && SkyBlockAPI.getIsland() != IslandType.DUNGEON && !this.slayerManager.isInQuest() && ConfigManager.getConfig().combat.cocoonedMob.cocoonedWarning;
    }

    private void onChangeWorld(class_310 _mc, class_638 _world) {
        this.lastWorldChange = System.currentTimeMillis();
        this.chain.clear();
    }

    private void onUpdateArmorStand(@NotNull class_1531 armorStandEntity, boolean equipment) {
        if (equipment || System.currentTimeMillis() - this.lastWorldChange < 10000L) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!this.isCocoon(armorStandEntity)) {
            return;
        }
        for (class_1531 as : this.chain) {
            if (as.method_5628() != armorStandEntity.method_5628()) continue;
            return;
        }
        this.chain.removeIf(a -> a.method_31481() || a.method_29504());
        if (this.chain.isEmpty()) {
            this.chain.addLast(armorStandEntity);
            return;
        }
        boolean closeToAny = false;
        for (class_1531 as : this.chain) {
            if (!(as.method_5858((class_1297)armorStandEntity) <= 4.0)) continue;
            closeToAny = true;
            break;
        }
        if (closeToAny) {
            this.chain.addLast(armorStandEntity);
            while (this.chain.size() > 3) {
                this.chain.removeFirst();
            }
            if (this.chain.size() == 3) {
                this.onReincarnationDetected();
                this.chain.clear();
            }
        } else {
            this.chain.clear();
            this.chain.addLast(armorStandEntity);
        }
    }

    private void onRemoveArmorStand(@NotNull class_1531 armorStand) {
        this.chain.removeIf(a -> a.method_5628() == armorStand.method_5628());
    }

    private void onReincarnationDetected() {
        Client.sendMessageWithPrefix((class_2561)class_2561.method_43470((String)"A reincarnation has been detected!").method_27692(class_124.field_1061));
        Client.showTitle((class_2561)class_2561.method_43470((String)"Cocooned!").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), 0, 40, 0);
        Client.playSoundNotificationChime();
    }

    private boolean isCocoon(@NotNull class_1531 as) {
        if (as.method_5807() || !as.method_6084(class_1304.field_6169)) {
            return false;
        }
        String headTexture = ItemUtils.getHeadTexture(as.method_6118(class_1304.field_6169));
        if (headTexture.isBlank()) {
            return false;
        }
        return headTexture.equals("eyJ0aW1lc3RhbXAiOjE1ODMxMjMyODkwNTMsInByb2ZpbGVJZCI6IjkxZjA0ZmU5MGYzNjQzYjU4ZjIwZTMzNzVmODZkMzllIiwicHJvZmlsZU5hbWUiOiJTdG9ybVN0b3JteSIsInNpZ25hdHVyZVJlcXVpcmVkIjp0cnVlLCJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGNlYjBlZDhmYzIyNzJiM2QzZDgyMDY3NmQ1MmEzOGU3YjJlOGRhOGM2ODdhMjMzZTBkYWJhYTE2YzBlOTZkZiJ9fX0=");
    }
}

