/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.diana;

import fr.siroz.cariboustonks.event.NetworkEvents;
import fr.siroz.cariboustonks.feature.diana.MythologicalRitualFeature;
import fr.siroz.cariboustonks.util.ItemUtils;
import fr.siroz.cariboustonks.util.math.bezier.ParticlePathPredictor;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2675;
import net.minecraft.class_9322;
import org.jetbrains.annotations.NotNull;

final class GuessBurrow {
    private final MythologicalRitualFeature mythologicalRitual;
    private final ParticlePathPredictor predictor;
    private long lastSpadeUsed = 0L;

    GuessBurrow(MythologicalRitualFeature mythologicalRitual) {
        this.mythologicalRitual = mythologicalRitual;
        this.predictor = new ParticlePathPredictor(3);
        UseItemCallback.EVENT.register(this::onUseItem);
        NetworkEvents.PARTICLE_RECEIVED_PACKET.register(this::onParticleReceived);
    }

    void reset() {
        this.predictor.reset();
        this.lastSpadeUsed = 0L;
    }

    private class_1269 onUseItem(@NotNull class_1657 player, class_1937 world, class_1268 hand) {
        class_1799 item = player.method_5998(hand);
        if (this.mythologicalRitual.isEnabled() && this.mythologicalRitual.isGuessEnabled() && ItemUtils.getSkyBlockItemId((class_9322)item).equals("ANCESTRAL_SPADE")) {
            this.predictor.reset();
            this.lastSpadeUsed = System.currentTimeMillis();
        }
        return class_1269.field_5811;
    }

    private void onParticleReceived(class_2675 particle) {
        if (!this.mythologicalRitual.isEnabled() || !this.mythologicalRitual.isGuessEnabled()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastSpadeUsed > 3000L) {
            return;
        }
        if (class_2398.field_11223.equals(particle.method_11551().method_10295()) && particle.method_11545() == 2 && particle.method_11543() == -0.5f) {
            class_243 position = new class_243(particle.method_11544(), particle.method_11547(), particle.method_11546());
            this.handleParticle(position);
        }
    }

    private void handleParticle(class_243 position) {
        if (this.predictor.isEmpty()) {
            this.predictor.addPoint(position);
            return;
        }
        class_243 lastPoint = this.predictor.getLastPoint();
        if (lastPoint == null) {
            return;
        }
        double distance = lastPoint.method_1022(position);
        if (distance == 0.0 || distance > 3.0) {
            return;
        }
        this.predictor.addPoint(position);
        class_243 solved = this.predictor.solve();
        if (solved == null) {
            return;
        }
        this.mythologicalRitual.onBurrowGuess(solved);
    }
}

