/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.diana;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import fr.siroz.cariboustonks.CaribouStonks;
import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.core.skyblock.IslandType;
import fr.siroz.cariboustonks.core.skyblock.SkyBlockAPI;
import fr.siroz.cariboustonks.event.ChatEvents;
import fr.siroz.cariboustonks.feature.Feature;
import fr.siroz.cariboustonks.feature.diana.GriffinBurrow;
import fr.siroz.cariboustonks.feature.diana.GriffinBurrowParticleFinder;
import fr.siroz.cariboustonks.feature.diana.GuessBurrow;
import fr.siroz.cariboustonks.feature.diana.NearestWarp;
import fr.siroz.cariboustonks.manager.command.CommandComponent;
import fr.siroz.cariboustonks.manager.glowing.EntityGlowProvider;
import fr.siroz.cariboustonks.manager.keybinds.KeyBind;
import fr.siroz.cariboustonks.manager.keybinds.KeyBindComponent;
import fr.siroz.cariboustonks.manager.waypoint.Waypoint;
import fr.siroz.cariboustonks.manager.waypoint.options.TextOption;
import fr.siroz.cariboustonks.util.Client;
import fr.siroz.cariboustonks.util.colors.Color;
import fr.siroz.cariboustonks.util.colors.Colors;
import fr.siroz.cariboustonks.util.position.Position;
import fr.siroz.cariboustonks.util.render.WorldRenderUtils;
import fr.siroz.cariboustonks.util.render.WorldRendererProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MythologicalRitualFeature
extends Feature
implements EntityGlowProvider,
WorldRendererProvider {
    private static final Pattern GRIFFIN_BURROW_DUG = Pattern.compile("(?<message>You dug out a Griffin Burrow!|You finished the Griffin burrow chain!) \\((?<index>\\d)/4\\)");
    private static final Pattern INQUISITOR_FOUND_PATTERN = Pattern.compile(".* You dug out a Minos Inquisitor!");
    private static final String INQUISITOR_ENTITY_NAME = "Minos Inquisitor";
    private final GriffinBurrowParticleFinder particleFinder;
    private final GuessBurrow guessBurrow;
    private final NearestWarp nearestWarp;
    private final KeyBind nearestWarpKeyBind;
    private final Map<class_2338, Waypoint> burrows = new HashMap<class_2338, Waypoint>();
    @Nullable
    private Waypoint guessWaypoint;
    @Nullable
    private Position currentInquisitorPosition;
    private boolean onDiana = false;

    public MythologicalRitualFeature() {
        this.particleFinder = new GriffinBurrowParticleFinder(this);
        this.guessBurrow = new GuessBurrow(this);
        this.nearestWarp = new NearestWarp(this);
        this.nearestWarpKeyBind = new KeyBind("Warp Diana", 70, true, this.nearestWarp::warpToNearestWarp);
        ChatEvents.MESSAGE_RECEIVED.register(this::onMessage);
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((client, world) -> this.resetAndClear());
        WorldRenderEvents.AFTER_TRANSLUCENT.register(this::render);
        this.addComponent(CommandComponent.class, d -> d.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cariboustonks").then(ClientCommandManager.literal((String)"resetDiana").executes(context -> {
            this.resetAndClear();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)CaribouStonks.prefix().get().method_10852((class_2561)class_2561.method_43470((String)"Diana reset successfully.").method_27692(class_124.field_1060)));
            return 1;
        }))));
        this.addComponent(KeyBindComponent.class, () -> Collections.singletonList(this.nearestWarpKeyBind));
    }

    @Override
    public boolean isEnabled() {
        return SkyBlockAPI.isOnSkyBlock() && SkyBlockAPI.getIsland() == IslandType.HUB && ConfigManager.getConfig().events.mythologicalRitual.enabled;
    }

    public boolean onPlayerFoundInquisitor(@Nullable String playerName, @NotNull Position position) {
        if (!this.isEnabled() || !this.onDiana) {
            return false;
        }
        if (playerName != null && !playerName.contains(CLIENT.method_1548().method_1676()) && this.isAcceptInquisitorShareEnabled()) {
            this.currentInquisitorPosition = position;
            this.nearestWarp.onInquisitor();
            TickScheduler.getInstance().runLater(() -> {
                this.currentInquisitorPosition = null;
            }, 30, TimeUnit.SECONDS);
            Client.sendMessageWithPrefix((class_2561)class_2561.method_43470((String)playerName).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}).method_10852((class_2561)class_2561.method_43470((String)" found an Inquisitor!").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067})));
            Client.playSound(class_3417.field_14588, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public int getEntityGlowColor(@NotNull class_1297 entity) {
        if (ConfigManager.getConfig().events.mythologicalRitual.highlightInquisitor && entity.method_5477().getString().contains(INQUISITOR_ENTITY_NAME)) {
            return ConfigManager.getConfig().events.mythologicalRitual.highlightInquisitorColor.getRGB();
        }
        return 0;
    }

    @Override
    public void render(WorldRenderContext context) {
        if (MythologicalRitualFeature.CLIENT.field_1724 == null || MythologicalRitualFeature.CLIENT.field_1687 == null) {
            return;
        }
        if (this.isGuessEnabled() && this.guessWaypoint != null) {
            this.guessWaypoint.getRenderer().render(context);
        }
        if (this.isParticleFinderEnabled()) {
            for (Waypoint waypoint2 : this.burrows.values()) {
                waypoint2.getRenderer().render(context);
            }
        }
        if (this.currentInquisitorPosition != null && this.isAcceptInquisitorShareEnabled()) {
            double distance = context.camera().method_19326().method_1022(this.currentInquisitorPosition.toVec3d());
            float scale = Math.max((float)distance / 5.0f, 1.0f);
            WorldRenderUtils.renderText(context, (class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"/K").method_27695(new class_124[]{class_124.field_1079, class_124.field_1051})).method_10852((class_2561)class_2561.method_43470((String)" Inquisitor ").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"/K").method_27695(new class_124[]{class_124.field_1079, class_124.field_1051})), this.currentInquisitorPosition.toVec3d().method_1031(0.0, 5.0, 0.0), scale, true);
        }
        if (!ConfigManager.getConfig().events.mythologicalRitual.lineToClosestBurrow) {
            return;
        }
        if (this.guessWaypoint != null && this.burrows.isEmpty()) {
            WorldRenderUtils.renderLineFromCursor(context, this.guessWaypoint.getPosition().toVec3d(), Colors.YELLOW, 1.0f);
        } else if (!this.burrows.isEmpty() && MythologicalRitualFeature.CLIENT.field_1724 != null) {
            Waypoint waypoint3;
            class_243 closest = null;
            double minDistanceSquared = Double.MAX_VALUE;
            List<class_243> positions = this.burrows.values().stream().map(waypoint -> waypoint.getPosition().toVec3d()).toList();
            for (class_243 pos : positions) {
                double distanceSquared = MythologicalRitualFeature.CLIENT.field_1724.method_19538().method_1025(pos);
                if (!(distanceSquared < minDistanceSquared)) continue;
                minDistanceSquared = distanceSquared;
                closest = pos;
            }
            if (closest != null && minDistanceSquared < 25600.0 && (waypoint3 = this.burrows.get(new class_2338((int)closest.field_1352, (int)closest.field_1351, (int)closest.field_1350))) != null) {
                WorldRenderUtils.renderLineFromCursor(context, closest.method_1031(0.5, 0.5, 0.5), waypoint3.getColor(), 1.0f);
            }
        }
    }

    private void onMessage(@NotNull class_2561 text) {
        Matcher inquisitorFoundMatcher;
        if (!this.isEnabled()) {
            return;
        }
        Matcher burrowDugMatcher = GRIFFIN_BURROW_DUG.matcher(text.getString());
        if (burrowDugMatcher.matches()) {
            this.onDiana = true;
            this.particleFinder.handleGriffinBurrowDugMessage();
        }
        if ((inquisitorFoundMatcher = INQUISITOR_FOUND_PATTERN.matcher(text.getString())).matches()) {
            Client.sendMessageWithPrefix((class_2561)class_2561.method_43470((String)"You found an Inquisitor!").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
            Client.showTitle((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"/K").method_27695(new class_124[]{class_124.field_1079, class_124.field_1051})).method_10852((class_2561)class_2561.method_43470((String)" Inquisitor ").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"/K").method_27695(new class_124[]{class_124.field_1079, class_124.field_1051})), 1, 80, 20);
            Client.playSound(class_3417.field_14792, 0.8f, 1.5f);
            if (MythologicalRitualFeature.CLIENT.field_1724 != null && ConfigManager.getConfig().events.mythologicalRitual.shareInquisitor) {
                Position position = Position.of(MythologicalRitualFeature.CLIENT.field_1724.method_19538());
                Client.sendChatMessage("/pc " + position.asChatCoordinates());
            }
        }
    }

    boolean isGuessEnabled() {
        return ConfigManager.getConfig().events.mythologicalRitual.guessBurrow;
    }

    boolean isParticleFinderEnabled() {
        return ConfigManager.getConfig().events.mythologicalRitual.burrowParticleFinder;
    }

    String getNearestWarpBoundKeyLocalized() {
        return this.nearestWarpKeyBind.getKeyBinding().method_16007().getString();
    }

    void onBurrowGuess(@Nullable class_243 location) {
        if (location == null) {
            return;
        }
        Position position = Position.of(location);
        this.guessWaypoint = Waypoint.builder(position).textOption(TextOption.builder().withText((class_2561)class_2561.method_43470((String)"Guess").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067, class_124.field_1056})).withDistance(true).withOffsetY(3).build()).color(Color.fromInt(ConfigManager.getConfig().events.mythologicalRitual.guessBurrowColor.getRGB())).build();
        if (ConfigManager.getConfig().events.mythologicalRitual.nearestWarp) {
            this.nearestWarp.shouldUseNearestWarp(position.toVec3d());
        }
    }

    void onBurrowDetected(@Nullable GriffinBurrow burrow) {
        Waypoint waypoint;
        if (burrow == null) {
            return;
        }
        if (this.burrows.containsKey(burrow.getPos())) {
            return;
        }
        Position position = Position.of(burrow.getPos());
        switch (burrow.getBurrowType()) {
            default: {
                throw new MatchException(null, null);
            }
            case START: {
                Waypoint waypoint2 = Waypoint.builder(Position.of(position)).textOption(TextOption.builder().withText((class_2561)class_2561.method_43470((String)"Start").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067})).withOffsetY(3).build()).color(Colors.GREEN).build();
                break;
            }
            case TREASURE: {
                Waypoint waypoint2 = Waypoint.builder(Position.of(position)).textOption(TextOption.builder().withText((class_2561)class_2561.method_43470((String)"Treasure").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})).withOffsetY(3).build()).color(Colors.ORANGE).build();
                break;
            }
            case MOB: {
                Waypoint waypoint2 = Waypoint.builder(Position.of(position)).textOption(TextOption.builder().withText((class_2561)class_2561.method_43470((String)"Mob").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})).withOffsetY(3).build()).color(Colors.RED).build();
                break;
            }
            case UNKNOWN: {
                Waypoint waypoint2 = waypoint = null;
            }
        }
        if (waypoint != null) {
            Client.playSound(class_3417.field_14627, 0.8f, 1.0f);
            this.burrows.putIfAbsent(burrow.getPos(), waypoint);
        }
    }

    void onBurrowDug(class_2338 pos) {
        this.burrows.remove(pos);
        this.burrows.remove(new class_2338(pos.method_10263(), pos.method_10264() + 1, pos.method_10260()));
        this.burrows.remove(new class_2338(pos.method_10263(), pos.method_10264() - 1, pos.method_10260()));
    }

    private boolean isAcceptInquisitorShareEnabled() {
        return ConfigManager.getConfig().events.mythologicalRitual.acceptInquisitorShare;
    }

    private void resetAndClear() {
        this.guessBurrow.reset();
        this.onDiana = false;
        this.guessWaypoint = null;
        this.burrows.clear();
        this.particleFinder.resetAndClear();
        this.nearestWarp.reset();
        this.currentInquisitorPosition = null;
    }
}

