/*
 * Decompiled with CFR 0.152.
 */
package fr.siroz.cariboustonks.feature.diana;

import fr.siroz.cariboustonks.config.ConfigManager;
import fr.siroz.cariboustonks.core.scheduler.TickScheduler;
import fr.siroz.cariboustonks.feature.diana.MythologicalRitualFeature;
import fr.siroz.cariboustonks.util.Client;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

final class NearestWarp {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final double CLOSE_TO_TARGET_DISTANCE_SQ = 10000.0;
    private static final double MIN_IMPROVEMENT_BLOCKS_SQ = 6400.0;
    private final MythologicalRitualFeature mythologicalRitual;
    private Warp targetWarp;
    private long lastTargetWarpTime;
    private boolean hasInquisitor = false;

    NearestWarp(MythologicalRitualFeature mythologicalRitual) {
        this.mythologicalRitual = mythologicalRitual;
        this.targetWarp = null;
        this.lastTargetWarpTime = 0L;
    }

    void reset() {
        this.targetWarp = null;
        this.lastTargetWarpTime = 0L;
        this.hasInquisitor = false;
    }

    void onInquisitor() {
        this.hasInquisitor = true;
        TickScheduler.getInstance().runLater(() -> {
            this.hasInquisitor = false;
        }, 20, TimeUnit.SECONDS);
    }

    void warpToNearestWarp() {
        if (!ConfigManager.getConfig().events.mythologicalRitual.nearestWarp) {
            return;
        }
        if (this.targetWarp == null) {
            return;
        }
        if (this.hasInquisitor) {
            return;
        }
        if (System.currentTimeMillis() - this.lastTargetWarpTime < 5000L) {
            return;
        }
        this.lastTargetWarpTime = System.currentTimeMillis();
        Client.sendChatMessage("/warp " + this.targetWarp.toString(), true);
        Client.clearTitleAndSubtitle();
        this.targetWarp = null;
    }

    void shouldUseNearestWarp(@NotNull class_243 target) {
        if (NearestWarp.CLIENT.field_1724 == null) {
            this.targetWarp = null;
            return;
        }
        if (this.hasInquisitor) {
            return;
        }
        class_243 playerPos = NearestWarp.CLIENT.field_1724.method_19538();
        double playerToTargetSq = playerPos.method_1025(target);
        if (playerToTargetSq <= 10000.0) {
            this.targetWarp = null;
            return;
        }
        Warp bestWarp = Arrays.stream(Warp.values()).filter(Warp::isEnabled).min(Comparator.comparingDouble(w -> w.getPosition().method_1025(target))).orElse(null);
        if (bestWarp == null) {
            this.targetWarp = null;
            return;
        }
        double warpToTargetSq = bestWarp.getPosition().method_1025(target);
        if (playerToTargetSq > warpToTargetSq + 6400.0) {
            this.targetWarp = bestWarp;
            this.show();
        } else {
            this.targetWarp = null;
        }
    }

    private void show() {
        if (this.targetWarp != null) {
            Client.showTitleAndSubtitle((class_2561)class_2561.method_43470((String)("Warp > " + this.targetWarp.getDisplayName())).method_27692(class_124.field_1075), (class_2561)class_2561.method_43470((String)("Press " + this.mythologicalRitual.getNearestWarpBoundKeyLocalized())).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}), 0, 40, 0);
        }
    }

    private static enum Warp {
        HUB("Hub", new class_243(-3.0, 70.0, -70.0), () -> true),
        CRYPT("Crypt", new class_243(190.0, 75.0, -88.0), () -> ConfigManager.getConfig().events.mythologicalRitual.warpToCrypt),
        CASTLE("Castle", new class_243(-250.0, 130.0, 45.0), () -> true),
        DA("Dark Auction", new class_243(90.0, 75.0, 170.0), () -> ConfigManager.getConfig().events.mythologicalRitual.warpToDarkAuction),
        MUSEUM("Museum", new class_243(-75.0, 75.0, 80.0), () -> true),
        WIZARD("Wizard", new class_243(45.0, 122.0, 69.0), () -> ConfigManager.getConfig().events.mythologicalRitual.warpToWizard),
        STONKS("Stonks", new class_243(-50.0, 70.0, -50.0), () -> ConfigManager.getConfig().events.mythologicalRitual.warpToStonks);

        private final String displayName;
        private final class_243 position;
        private final Supplier<Boolean> enabled;

        private Warp(String displayName, class_243 position, Supplier<Boolean> enabled) {
            this.displayName = displayName;
            this.position = position;
            this.enabled = enabled;
        }

        public class_243 getPosition() {
            return this.position;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean isEnabled() {
            return this.enabled.get();
        }
    }
}

